/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.TLSProfileSpec;
import io.fabric8.openshift.api.model.TLSProfileSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TLSProfileSpecFluentImpl<A extends TLSProfileSpecFluent<A>>
extends BaseFluent<A>
implements TLSProfileSpecFluent<A> {
    private List<String> ciphers = new ArrayList<String>();
    private String minTLSVersion;
    private Map<String, Object> additionalProperties;

    public TLSProfileSpecFluentImpl() {
    }

    public TLSProfileSpecFluentImpl(TLSProfileSpec instance) {
        this.withCiphers(instance.getCiphers());
        this.withMinTLSVersion(instance.getMinTLSVersion());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToCiphers(Integer index, String item) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        this.ciphers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCiphers(Integer index, String item) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        this.ciphers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCiphers(String ... items) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        for (String item : items) {
            this.ciphers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCiphers(Collection<String> items) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        for (String item : items) {
            this.ciphers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCiphers(String ... items) {
        for (String item : items) {
            if (this.ciphers == null) continue;
            this.ciphers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCiphers(Collection<String> items) {
        for (String item : items) {
            if (this.ciphers == null) continue;
            this.ciphers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCiphers() {
        return this.ciphers;
    }

    @Override
    public String getCipher(Integer index) {
        return this.ciphers.get(index);
    }

    @Override
    public String getFirstCipher() {
        return this.ciphers.get(0);
    }

    @Override
    public String getLastCipher() {
        return this.ciphers.get(this.ciphers.size() - 1);
    }

    @Override
    public String getMatchingCipher(Predicate<String> predicate) {
        for (String item : this.ciphers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCipher(Predicate<String> predicate) {
        for (String item : this.ciphers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCiphers(List<String> ciphers) {
        if (ciphers != null) {
            this.ciphers = new ArrayList<String>();
            for (String item : ciphers) {
                this.addToCiphers(item);
            }
        } else {
            this.ciphers = null;
        }
        return (A)this;
    }

    @Override
    public A withCiphers(String ... ciphers) {
        if (this.ciphers != null) {
            this.ciphers.clear();
        }
        if (ciphers != null) {
            for (String item : ciphers) {
                this.addToCiphers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCiphers() {
        return this.ciphers != null && !this.ciphers.isEmpty();
    }

    @Override
    public String getMinTLSVersion() {
        return this.minTLSVersion;
    }

    @Override
    public A withMinTLSVersion(String minTLSVersion) {
        this.minTLSVersion = minTLSVersion;
        return (A)this;
    }

    @Override
    public Boolean hasMinTLSVersion() {
        return this.minTLSVersion != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TLSProfileSpecFluentImpl that = (TLSProfileSpecFluentImpl)o;
        if (this.ciphers != null ? !this.ciphers.equals(that.ciphers) : that.ciphers != null) {
            return false;
        }
        if (this.minTLSVersion != null ? !this.minTLSVersion.equals(that.minTLSVersion) : that.minTLSVersion != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ciphers, this.minTLSVersion, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ciphers != null && !this.ciphers.isEmpty()) {
            sb.append("ciphers:");
            sb.append(this.ciphers + ",");
        }
        if (this.minTLSVersion != null) {
            sb.append("minTLSVersion:");
            sb.append(this.minTLSVersion + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

