/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.Ingress;
import io.fabric8.openshift.api.model.IngressFluent;
import io.fabric8.openshift.api.model.IngressFluentImpl;

public class IngressBuilder
extends IngressFluentImpl<IngressBuilder>
implements VisitableBuilder<Ingress, IngressBuilder> {
    IngressFluent<?> fluent;
    Boolean validationEnabled;

    public IngressBuilder() {
        this(false);
    }

    public IngressBuilder(Boolean validationEnabled) {
        this(new Ingress(), validationEnabled);
    }

    public IngressBuilder(IngressFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public IngressBuilder(IngressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Ingress(), validationEnabled);
    }

    public IngressBuilder(IngressFluent<?> fluent, Ingress instance) {
        this(fluent, instance, false);
    }

    public IngressBuilder(IngressFluent<?> fluent, Ingress instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public IngressBuilder(Ingress instance) {
        this(instance, (Boolean)false);
    }

    public IngressBuilder(Ingress instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Ingress build() {
        Ingress buildable = new Ingress(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

