/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageBuilder;
import io.fabric8.openshift.api.model.ImageFluentImpl;
import io.fabric8.openshift.api.model.ImageImportStatus;
import io.fabric8.openshift.api.model.ImageImportStatusFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ImageImportStatusFluentImpl<A extends ImageImportStatusFluent<A>>
extends BaseFluent<A>
implements ImageImportStatusFluent<A> {
    private ImageBuilder image;
    private Status status;
    private String tag;
    private Map<String, Object> additionalProperties;

    public ImageImportStatusFluentImpl() {
    }

    public ImageImportStatusFluentImpl(ImageImportStatus instance) {
        this.withImage(instance.getImage());
        this.withStatus(instance.getStatus());
        this.withTag(instance.getTag());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public Image getImage() {
        return this.image != null ? this.image.build() : null;
    }

    @Override
    public Image buildImage() {
        return this.image != null ? this.image.build() : null;
    }

    @Override
    public A withImage(Image image) {
        this._visitables.get("image").remove(this.image);
        if (image != null) {
            this.image = new ImageBuilder(image);
            this._visitables.get("image").add(this.image);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public ImageImportStatusFluent.ImageNested<A> withNewImage() {
        return new ImageNestedImpl();
    }

    @Override
    public ImageImportStatusFluent.ImageNested<A> withNewImageLike(Image item) {
        return new ImageNestedImpl(item);
    }

    @Override
    public ImageImportStatusFluent.ImageNested<A> editImage() {
        return this.withNewImageLike(this.getImage());
    }

    @Override
    public ImageImportStatusFluent.ImageNested<A> editOrNewImage() {
        return this.withNewImageLike(this.getImage() != null ? this.getImage() : new ImageBuilder().build());
    }

    @Override
    public ImageImportStatusFluent.ImageNested<A> editOrNewImageLike(Image item) {
        return this.withNewImageLike(this.getImage() != null ? this.getImage() : item);
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public A withStatus(Status status) {
        this.status = status;
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public A withTag(String tag) {
        this.tag = tag;
        return (A)this;
    }

    @Override
    public Boolean hasTag() {
        return this.tag != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageImportStatusFluentImpl that = (ImageImportStatusFluentImpl)o;
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        if (this.tag != null ? !this.tag.equals(that.tag) : that.tag != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.image, this.status, this.tag, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status + ",");
        }
        if (this.tag != null) {
            sb.append("tag:");
            sb.append(this.tag + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ImageNestedImpl<N>
    extends ImageFluentImpl<ImageImportStatusFluent.ImageNested<N>>
    implements ImageImportStatusFluent.ImageNested<N>,
    Nested<N> {
        ImageBuilder builder;

        ImageNestedImpl(Image item) {
            this.builder = new ImageBuilder(this, item);
        }

        ImageNestedImpl() {
            this.builder = new ImageBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageImportStatusFluentImpl.this.withImage(this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }
}

