/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ConfigMapNameReference;
import io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.ConfigMapNameReferenceFluentImpl;
import io.fabric8.openshift.api.model.ConnectionConfig;
import io.fabric8.openshift.api.model.ConnectionConfigFluent;
import io.fabric8.openshift.api.model.SecretNameReference;
import io.fabric8.openshift.api.model.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.SecretNameReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ConnectionConfigFluentImpl<A extends ConnectionConfigFluent<A>>
extends BaseFluent<A>
implements ConnectionConfigFluent<A> {
    private ConfigMapNameReferenceBuilder ca;
    private SecretNameReferenceBuilder tlsClientConfig;
    private String url;
    private Map<String, Object> additionalProperties;

    public ConnectionConfigFluentImpl() {
    }

    public ConnectionConfigFluentImpl(ConnectionConfig instance) {
        this.withCa(instance.getCa());
        this.withTlsClientConfig(instance.getTlsClientConfig());
        this.withUrl(instance.getUrl());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public ConfigMapNameReference getCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    @Override
    public ConfigMapNameReference buildCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    @Override
    public A withCa(ConfigMapNameReference ca) {
        this._visitables.get("ca").remove(this.ca);
        if (ca != null) {
            this.ca = new ConfigMapNameReferenceBuilder(ca);
            this._visitables.get("ca").add(this.ca);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCa() {
        return this.ca != null;
    }

    @Override
    public A withNewCa(String name) {
        return this.withCa(new ConfigMapNameReference(name));
    }

    @Override
    public ConnectionConfigFluent.CaNested<A> withNewCa() {
        return new CaNestedImpl();
    }

    @Override
    public ConnectionConfigFluent.CaNested<A> withNewCaLike(ConfigMapNameReference item) {
        return new CaNestedImpl(item);
    }

    @Override
    public ConnectionConfigFluent.CaNested<A> editCa() {
        return this.withNewCaLike(this.getCa());
    }

    @Override
    public ConnectionConfigFluent.CaNested<A> editOrNewCa() {
        return this.withNewCaLike(this.getCa() != null ? this.getCa() : new ConfigMapNameReferenceBuilder().build());
    }

    @Override
    public ConnectionConfigFluent.CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
        return this.withNewCaLike(this.getCa() != null ? this.getCa() : item);
    }

    @Override
    @Deprecated
    public SecretNameReference getTlsClientConfig() {
        return this.tlsClientConfig != null ? this.tlsClientConfig.build() : null;
    }

    @Override
    public SecretNameReference buildTlsClientConfig() {
        return this.tlsClientConfig != null ? this.tlsClientConfig.build() : null;
    }

    @Override
    public A withTlsClientConfig(SecretNameReference tlsClientConfig) {
        this._visitables.get("tlsClientConfig").remove(this.tlsClientConfig);
        if (tlsClientConfig != null) {
            this.tlsClientConfig = new SecretNameReferenceBuilder(tlsClientConfig);
            this._visitables.get("tlsClientConfig").add(this.tlsClientConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsClientConfig() {
        return this.tlsClientConfig != null;
    }

    @Override
    public A withNewTlsClientConfig(String name) {
        return this.withTlsClientConfig(new SecretNameReference(name));
    }

    @Override
    public ConnectionConfigFluent.TlsClientConfigNested<A> withNewTlsClientConfig() {
        return new TlsClientConfigNestedImpl();
    }

    @Override
    public ConnectionConfigFluent.TlsClientConfigNested<A> withNewTlsClientConfigLike(SecretNameReference item) {
        return new TlsClientConfigNestedImpl(item);
    }

    @Override
    public ConnectionConfigFluent.TlsClientConfigNested<A> editTlsClientConfig() {
        return this.withNewTlsClientConfigLike(this.getTlsClientConfig());
    }

    @Override
    public ConnectionConfigFluent.TlsClientConfigNested<A> editOrNewTlsClientConfig() {
        return this.withNewTlsClientConfigLike(this.getTlsClientConfig() != null ? this.getTlsClientConfig() : new SecretNameReferenceBuilder().build());
    }

    @Override
    public ConnectionConfigFluent.TlsClientConfigNested<A> editOrNewTlsClientConfigLike(SecretNameReference item) {
        return this.withNewTlsClientConfigLike(this.getTlsClientConfig() != null ? this.getTlsClientConfig() : item);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    @Override
    public Boolean hasUrl() {
        return this.url != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionConfigFluentImpl that = (ConnectionConfigFluentImpl)o;
        if (this.ca != null ? !this.ca.equals(that.ca) : that.ca != null) {
            return false;
        }
        if (this.tlsClientConfig != null ? !this.tlsClientConfig.equals(that.tlsClientConfig) : that.tlsClientConfig != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ca, this.tlsClientConfig, this.url, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ca != null) {
            sb.append("ca:");
            sb.append(this.ca + ",");
        }
        if (this.tlsClientConfig != null) {
            sb.append("tlsClientConfig:");
            sb.append(this.tlsClientConfig + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class TlsClientConfigNestedImpl<N>
    extends SecretNameReferenceFluentImpl<ConnectionConfigFluent.TlsClientConfigNested<N>>
    implements ConnectionConfigFluent.TlsClientConfigNested<N>,
    Nested<N> {
        SecretNameReferenceBuilder builder;

        TlsClientConfigNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        TlsClientConfigNestedImpl() {
            this.builder = new SecretNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConnectionConfigFluentImpl.this.withTlsClientConfig(this.builder.build());
        }

        @Override
        public N endTlsClientConfig() {
            return this.and();
        }
    }

    class CaNestedImpl<N>
    extends ConfigMapNameReferenceFluentImpl<ConnectionConfigFluent.CaNested<N>>
    implements ConnectionConfigFluent.CaNested<N>,
    Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        CaNestedImpl(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        CaNestedImpl() {
            this.builder = new ConfigMapNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConnectionConfigFluentImpl.this.withCa(this.builder.build());
        }

        @Override
        public N endCa() {
            return this.and();
        }
    }
}

