/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ClusterOperatorStatusCondition;
import io.fabric8.openshift.api.model.ClusterOperatorStatusConditionBuilder;
import io.fabric8.openshift.api.model.ClusterOperatorStatusConditionFluentImpl;
import io.fabric8.openshift.api.model.ClusterVersionStatus;
import io.fabric8.openshift.api.model.ClusterVersionStatusFluent;
import io.fabric8.openshift.api.model.ConditionalUpdate;
import io.fabric8.openshift.api.model.ConditionalUpdateBuilder;
import io.fabric8.openshift.api.model.ConditionalUpdateFluentImpl;
import io.fabric8.openshift.api.model.Release;
import io.fabric8.openshift.api.model.ReleaseBuilder;
import io.fabric8.openshift.api.model.ReleaseFluentImpl;
import io.fabric8.openshift.api.model.UpdateHistory;
import io.fabric8.openshift.api.model.UpdateHistoryBuilder;
import io.fabric8.openshift.api.model.UpdateHistoryFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterVersionStatusFluentImpl<A extends ClusterVersionStatusFluent<A>>
extends BaseFluent<A>
implements ClusterVersionStatusFluent<A> {
    private ArrayList<ReleaseBuilder> availableUpdates = new ArrayList();
    private ArrayList<ConditionalUpdateBuilder> conditionalUpdates = new ArrayList();
    private ArrayList<ClusterOperatorStatusConditionBuilder> conditions = new ArrayList();
    private ReleaseBuilder desired;
    private ArrayList<UpdateHistoryBuilder> history = new ArrayList();
    private Long observedGeneration;
    private String versionHash;
    private Map<String, Object> additionalProperties;

    public ClusterVersionStatusFluentImpl() {
    }

    public ClusterVersionStatusFluentImpl(ClusterVersionStatus instance) {
        this.withAvailableUpdates(instance.getAvailableUpdates());
        this.withConditionalUpdates(instance.getConditionalUpdates());
        this.withConditions(instance.getConditions());
        this.withDesired(instance.getDesired());
        this.withHistory(instance.getHistory());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withVersionHash(instance.getVersionHash());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToAvailableUpdates(Integer index, Release item) {
        if (this.availableUpdates == null) {
            this.availableUpdates = new ArrayList();
        }
        ReleaseBuilder builder = new ReleaseBuilder(item);
        this._visitables.get("availableUpdates").add(index >= 0 ? index.intValue() : this._visitables.get("availableUpdates").size(), builder);
        this.availableUpdates.add(index >= 0 ? index.intValue() : this.availableUpdates.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAvailableUpdates(Integer index, Release item) {
        if (this.availableUpdates == null) {
            this.availableUpdates = new ArrayList();
        }
        ReleaseBuilder builder = new ReleaseBuilder(item);
        if (index < 0 || index >= this._visitables.get("availableUpdates").size()) {
            this._visitables.get("availableUpdates").add(builder);
        } else {
            this._visitables.get("availableUpdates").set(index, builder);
        }
        if (index < 0 || index >= this.availableUpdates.size()) {
            this.availableUpdates.add(builder);
        } else {
            this.availableUpdates.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAvailableUpdates(Release ... items) {
        if (this.availableUpdates == null) {
            this.availableUpdates = new ArrayList();
        }
        for (Release item : items) {
            ReleaseBuilder builder = new ReleaseBuilder(item);
            this._visitables.get("availableUpdates").add(builder);
            this.availableUpdates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAvailableUpdates(Collection<Release> items) {
        if (this.availableUpdates == null) {
            this.availableUpdates = new ArrayList();
        }
        for (Release item : items) {
            ReleaseBuilder builder = new ReleaseBuilder(item);
            this._visitables.get("availableUpdates").add(builder);
            this.availableUpdates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAvailableUpdates(Release ... items) {
        for (Release item : items) {
            ReleaseBuilder builder = new ReleaseBuilder(item);
            this._visitables.get("availableUpdates").remove(builder);
            if (this.availableUpdates == null) continue;
            this.availableUpdates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAvailableUpdates(Collection<Release> items) {
        for (Release item : items) {
            ReleaseBuilder builder = new ReleaseBuilder(item);
            this._visitables.get("availableUpdates").remove(builder);
            if (this.availableUpdates == null) continue;
            this.availableUpdates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAvailableUpdates(Predicate<ReleaseBuilder> predicate) {
        if (this.availableUpdates == null) {
            return (A)this;
        }
        Iterator<ReleaseBuilder> each = this.availableUpdates.iterator();
        Object visitables = this._visitables.get("availableUpdates");
        while (each.hasNext()) {
            ReleaseBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Release> getAvailableUpdates() {
        return this.availableUpdates != null ? ClusterVersionStatusFluentImpl.build(this.availableUpdates) : null;
    }

    @Override
    public List<Release> buildAvailableUpdates() {
        return this.availableUpdates != null ? ClusterVersionStatusFluentImpl.build(this.availableUpdates) : null;
    }

    @Override
    public Release buildAvailableUpdate(Integer index) {
        return this.availableUpdates.get(index).build();
    }

    @Override
    public Release buildFirstAvailableUpdate() {
        return this.availableUpdates.get(0).build();
    }

    @Override
    public Release buildLastAvailableUpdate() {
        return this.availableUpdates.get(this.availableUpdates.size() - 1).build();
    }

    @Override
    public Release buildMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate) {
        for (ReleaseBuilder item : this.availableUpdates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate) {
        for (ReleaseBuilder item : this.availableUpdates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAvailableUpdates(List<Release> availableUpdates) {
        if (this.availableUpdates != null) {
            this._visitables.get("availableUpdates").removeAll(this.availableUpdates);
        }
        if (availableUpdates != null) {
            this.availableUpdates = new ArrayList();
            for (Release item : availableUpdates) {
                this.addToAvailableUpdates(item);
            }
        } else {
            this.availableUpdates = null;
        }
        return (A)this;
    }

    @Override
    public A withAvailableUpdates(Release ... availableUpdates) {
        if (this.availableUpdates != null) {
            this.availableUpdates.clear();
        }
        if (availableUpdates != null) {
            for (Release item : availableUpdates) {
                this.addToAvailableUpdates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAvailableUpdates() {
        return this.availableUpdates != null && !this.availableUpdates.isEmpty();
    }

    @Override
    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> addNewAvailableUpdate() {
        return new AvailableUpdatesNestedImpl();
    }

    @Override
    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> addNewAvailableUpdateLike(Release item) {
        return new AvailableUpdatesNestedImpl(-1, item);
    }

    @Override
    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> setNewAvailableUpdateLike(Integer index, Release item) {
        return new AvailableUpdatesNestedImpl(index, item);
    }

    @Override
    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> editAvailableUpdate(Integer index) {
        if (this.availableUpdates.size() <= index) {
            throw new RuntimeException("Can't edit availableUpdates. Index exceeds size.");
        }
        return this.setNewAvailableUpdateLike(index, this.buildAvailableUpdate(index));
    }

    @Override
    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> editFirstAvailableUpdate() {
        if (this.availableUpdates.size() == 0) {
            throw new RuntimeException("Can't edit first availableUpdates. The list is empty.");
        }
        return this.setNewAvailableUpdateLike(0, this.buildAvailableUpdate(0));
    }

    @Override
    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> editLastAvailableUpdate() {
        int index = this.availableUpdates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last availableUpdates. The list is empty.");
        }
        return this.setNewAvailableUpdateLike(index, this.buildAvailableUpdate(index));
    }

    @Override
    public ClusterVersionStatusFluent.AvailableUpdatesNested<A> editMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.availableUpdates.size(); ++i) {
            if (!predicate.test(this.availableUpdates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching availableUpdates. No match found.");
        }
        return this.setNewAvailableUpdateLike(index, this.buildAvailableUpdate(index));
    }

    @Override
    public A addToConditionalUpdates(Integer index, ConditionalUpdate item) {
        if (this.conditionalUpdates == null) {
            this.conditionalUpdates = new ArrayList();
        }
        ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);
        this._visitables.get("conditionalUpdates").add(index >= 0 ? index.intValue() : this._visitables.get("conditionalUpdates").size(), builder);
        this.conditionalUpdates.add(index >= 0 ? index.intValue() : this.conditionalUpdates.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditionalUpdates(Integer index, ConditionalUpdate item) {
        if (this.conditionalUpdates == null) {
            this.conditionalUpdates = new ArrayList();
        }
        ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditionalUpdates").size()) {
            this._visitables.get("conditionalUpdates").add(builder);
        } else {
            this._visitables.get("conditionalUpdates").set(index, builder);
        }
        if (index < 0 || index >= this.conditionalUpdates.size()) {
            this.conditionalUpdates.add(builder);
        } else {
            this.conditionalUpdates.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditionalUpdates(ConditionalUpdate ... items) {
        if (this.conditionalUpdates == null) {
            this.conditionalUpdates = new ArrayList();
        }
        for (ConditionalUpdate item : items) {
            ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);
            this._visitables.get("conditionalUpdates").add(builder);
            this.conditionalUpdates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditionalUpdates(Collection<ConditionalUpdate> items) {
        if (this.conditionalUpdates == null) {
            this.conditionalUpdates = new ArrayList();
        }
        for (ConditionalUpdate item : items) {
            ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);
            this._visitables.get("conditionalUpdates").add(builder);
            this.conditionalUpdates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditionalUpdates(ConditionalUpdate ... items) {
        for (ConditionalUpdate item : items) {
            ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);
            this._visitables.get("conditionalUpdates").remove(builder);
            if (this.conditionalUpdates == null) continue;
            this.conditionalUpdates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditionalUpdates(Collection<ConditionalUpdate> items) {
        for (ConditionalUpdate item : items) {
            ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);
            this._visitables.get("conditionalUpdates").remove(builder);
            if (this.conditionalUpdates == null) continue;
            this.conditionalUpdates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditionalUpdates(Predicate<ConditionalUpdateBuilder> predicate) {
        if (this.conditionalUpdates == null) {
            return (A)this;
        }
        Iterator<ConditionalUpdateBuilder> each = this.conditionalUpdates.iterator();
        Object visitables = this._visitables.get("conditionalUpdates");
        while (each.hasNext()) {
            ConditionalUpdateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ConditionalUpdate> getConditionalUpdates() {
        return this.conditionalUpdates != null ? ClusterVersionStatusFluentImpl.build(this.conditionalUpdates) : null;
    }

    @Override
    public List<ConditionalUpdate> buildConditionalUpdates() {
        return this.conditionalUpdates != null ? ClusterVersionStatusFluentImpl.build(this.conditionalUpdates) : null;
    }

    @Override
    public ConditionalUpdate buildConditionalUpdate(Integer index) {
        return this.conditionalUpdates.get(index).build();
    }

    @Override
    public ConditionalUpdate buildFirstConditionalUpdate() {
        return this.conditionalUpdates.get(0).build();
    }

    @Override
    public ConditionalUpdate buildLastConditionalUpdate() {
        return this.conditionalUpdates.get(this.conditionalUpdates.size() - 1).build();
    }

    @Override
    public ConditionalUpdate buildMatchingConditionalUpdate(Predicate<ConditionalUpdateBuilder> predicate) {
        for (ConditionalUpdateBuilder item : this.conditionalUpdates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingConditionalUpdate(Predicate<ConditionalUpdateBuilder> predicate) {
        for (ConditionalUpdateBuilder item : this.conditionalUpdates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditionalUpdates(List<ConditionalUpdate> conditionalUpdates) {
        if (this.conditionalUpdates != null) {
            this._visitables.get("conditionalUpdates").removeAll(this.conditionalUpdates);
        }
        if (conditionalUpdates != null) {
            this.conditionalUpdates = new ArrayList();
            for (ConditionalUpdate item : conditionalUpdates) {
                this.addToConditionalUpdates(item);
            }
        } else {
            this.conditionalUpdates = null;
        }
        return (A)this;
    }

    @Override
    public A withConditionalUpdates(ConditionalUpdate ... conditionalUpdates) {
        if (this.conditionalUpdates != null) {
            this.conditionalUpdates.clear();
        }
        if (conditionalUpdates != null) {
            for (ConditionalUpdate item : conditionalUpdates) {
                this.addToConditionalUpdates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditionalUpdates() {
        return this.conditionalUpdates != null && !this.conditionalUpdates.isEmpty();
    }

    @Override
    public ClusterVersionStatusFluent.ConditionalUpdatesNested<A> addNewConditionalUpdate() {
        return new ConditionalUpdatesNestedImpl();
    }

    @Override
    public ClusterVersionStatusFluent.ConditionalUpdatesNested<A> addNewConditionalUpdateLike(ConditionalUpdate item) {
        return new ConditionalUpdatesNestedImpl(-1, item);
    }

    @Override
    public ClusterVersionStatusFluent.ConditionalUpdatesNested<A> setNewConditionalUpdateLike(Integer index, ConditionalUpdate item) {
        return new ConditionalUpdatesNestedImpl(index, item);
    }

    @Override
    public ClusterVersionStatusFluent.ConditionalUpdatesNested<A> editConditionalUpdate(Integer index) {
        if (this.conditionalUpdates.size() <= index) {
            throw new RuntimeException("Can't edit conditionalUpdates. Index exceeds size.");
        }
        return this.setNewConditionalUpdateLike(index, this.buildConditionalUpdate(index));
    }

    @Override
    public ClusterVersionStatusFluent.ConditionalUpdatesNested<A> editFirstConditionalUpdate() {
        if (this.conditionalUpdates.size() == 0) {
            throw new RuntimeException("Can't edit first conditionalUpdates. The list is empty.");
        }
        return this.setNewConditionalUpdateLike(0, this.buildConditionalUpdate(0));
    }

    @Override
    public ClusterVersionStatusFluent.ConditionalUpdatesNested<A> editLastConditionalUpdate() {
        int index = this.conditionalUpdates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditionalUpdates. The list is empty.");
        }
        return this.setNewConditionalUpdateLike(index, this.buildConditionalUpdate(index));
    }

    @Override
    public ClusterVersionStatusFluent.ConditionalUpdatesNested<A> editMatchingConditionalUpdate(Predicate<ConditionalUpdateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditionalUpdates.size(); ++i) {
            if (!predicate.test(this.conditionalUpdates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditionalUpdates. No match found.");
        }
        return this.setNewConditionalUpdateLike(index, this.buildConditionalUpdate(index));
    }

    @Override
    public A addToConditions(Integer index, ClusterOperatorStatusCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index.intValue() : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, ClusterOperatorStatusCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(ClusterOperatorStatusCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ClusterOperatorStatusCondition item : items) {
            ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<ClusterOperatorStatusCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ClusterOperatorStatusCondition item : items) {
            ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(ClusterOperatorStatusCondition ... items) {
        for (ClusterOperatorStatusCondition item : items) {
            ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<ClusterOperatorStatusCondition> items) {
        for (ClusterOperatorStatusCondition item : items) {
            ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ClusterOperatorStatusConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            ClusterOperatorStatusConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClusterOperatorStatusCondition> getConditions() {
        return this.conditions != null ? ClusterVersionStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<ClusterOperatorStatusCondition> buildConditions() {
        return this.conditions != null ? ClusterVersionStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public ClusterOperatorStatusCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public ClusterOperatorStatusCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public ClusterOperatorStatusCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public ClusterOperatorStatusCondition buildMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        for (ClusterOperatorStatusConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        for (ClusterOperatorStatusConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<ClusterOperatorStatusCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (ClusterOperatorStatusCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(ClusterOperatorStatusCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (ClusterOperatorStatusCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new ClusterOperatorStatusCondition(lastTransitionTime, message, reason, status, type));
    }

    @Override
    public ClusterVersionStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public ClusterVersionStatusFluent.ConditionsNested<A> addNewConditionLike(ClusterOperatorStatusCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public ClusterVersionStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, ClusterOperatorStatusCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public ClusterVersionStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ClusterVersionStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public ClusterVersionStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ClusterVersionStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    @Deprecated
    public Release getDesired() {
        return this.desired != null ? this.desired.build() : null;
    }

    @Override
    public Release buildDesired() {
        return this.desired != null ? this.desired.build() : null;
    }

    @Override
    public A withDesired(Release desired) {
        this._visitables.get("desired").remove(this.desired);
        if (desired != null) {
            this.desired = new ReleaseBuilder(desired);
            this._visitables.get("desired").add(this.desired);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDesired() {
        return this.desired != null;
    }

    @Override
    public ClusterVersionStatusFluent.DesiredNested<A> withNewDesired() {
        return new DesiredNestedImpl();
    }

    @Override
    public ClusterVersionStatusFluent.DesiredNested<A> withNewDesiredLike(Release item) {
        return new DesiredNestedImpl(item);
    }

    @Override
    public ClusterVersionStatusFluent.DesiredNested<A> editDesired() {
        return this.withNewDesiredLike(this.getDesired());
    }

    @Override
    public ClusterVersionStatusFluent.DesiredNested<A> editOrNewDesired() {
        return this.withNewDesiredLike(this.getDesired() != null ? this.getDesired() : new ReleaseBuilder().build());
    }

    @Override
    public ClusterVersionStatusFluent.DesiredNested<A> editOrNewDesiredLike(Release item) {
        return this.withNewDesiredLike(this.getDesired() != null ? this.getDesired() : item);
    }

    @Override
    public A addToHistory(Integer index, UpdateHistory item) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);
        this._visitables.get("history").add(index >= 0 ? index.intValue() : this._visitables.get("history").size(), builder);
        this.history.add(index >= 0 ? index.intValue() : this.history.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHistory(Integer index, UpdateHistory item) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);
        if (index < 0 || index >= this._visitables.get("history").size()) {
            this._visitables.get("history").add(builder);
        } else {
            this._visitables.get("history").set(index, builder);
        }
        if (index < 0 || index >= this.history.size()) {
            this.history.add(builder);
        } else {
            this.history.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHistory(UpdateHistory ... items) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        for (UpdateHistory item : items) {
            UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);
            this._visitables.get("history").add(builder);
            this.history.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHistory(Collection<UpdateHistory> items) {
        if (this.history == null) {
            this.history = new ArrayList();
        }
        for (UpdateHistory item : items) {
            UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);
            this._visitables.get("history").add(builder);
            this.history.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHistory(UpdateHistory ... items) {
        for (UpdateHistory item : items) {
            UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);
            this._visitables.get("history").remove(builder);
            if (this.history == null) continue;
            this.history.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHistory(Collection<UpdateHistory> items) {
        for (UpdateHistory item : items) {
            UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);
            this._visitables.get("history").remove(builder);
            if (this.history == null) continue;
            this.history.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHistory(Predicate<UpdateHistoryBuilder> predicate) {
        if (this.history == null) {
            return (A)this;
        }
        Iterator<UpdateHistoryBuilder> each = this.history.iterator();
        Object visitables = this._visitables.get("history");
        while (each.hasNext()) {
            UpdateHistoryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<UpdateHistory> getHistory() {
        return this.history != null ? ClusterVersionStatusFluentImpl.build(this.history) : null;
    }

    @Override
    public List<UpdateHistory> buildHistory() {
        return this.history != null ? ClusterVersionStatusFluentImpl.build(this.history) : null;
    }

    @Override
    public UpdateHistory buildHistory(Integer index) {
        return this.history.get(index).build();
    }

    @Override
    public UpdateHistory buildFirstHistory() {
        return this.history.get(0).build();
    }

    @Override
    public UpdateHistory buildLastHistory() {
        return this.history.get(this.history.size() - 1).build();
    }

    @Override
    public UpdateHistory buildMatchingHistory(Predicate<UpdateHistoryBuilder> predicate) {
        for (UpdateHistoryBuilder item : this.history) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHistory(Predicate<UpdateHistoryBuilder> predicate) {
        for (UpdateHistoryBuilder item : this.history) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHistory(List<UpdateHistory> history) {
        if (this.history != null) {
            this._visitables.get("history").removeAll(this.history);
        }
        if (history != null) {
            this.history = new ArrayList();
            for (UpdateHistory item : history) {
                this.addToHistory(item);
            }
        } else {
            this.history = null;
        }
        return (A)this;
    }

    @Override
    public A withHistory(UpdateHistory ... history) {
        if (this.history != null) {
            this.history.clear();
        }
        if (history != null) {
            for (UpdateHistory item : history) {
                this.addToHistory(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHistory() {
        return this.history != null && !this.history.isEmpty();
    }

    @Override
    public ClusterVersionStatusFluent.HistoryNested<A> addNewHistory() {
        return new HistoryNestedImpl();
    }

    @Override
    public ClusterVersionStatusFluent.HistoryNested<A> addNewHistoryLike(UpdateHistory item) {
        return new HistoryNestedImpl(-1, item);
    }

    @Override
    public ClusterVersionStatusFluent.HistoryNested<A> setNewHistoryLike(Integer index, UpdateHistory item) {
        return new HistoryNestedImpl(index, item);
    }

    @Override
    public ClusterVersionStatusFluent.HistoryNested<A> editHistory(Integer index) {
        if (this.history.size() <= index) {
            throw new RuntimeException("Can't edit history. Index exceeds size.");
        }
        return this.setNewHistoryLike(index, this.buildHistory(index));
    }

    @Override
    public ClusterVersionStatusFluent.HistoryNested<A> editFirstHistory() {
        if (this.history.size() == 0) {
            throw new RuntimeException("Can't edit first history. The list is empty.");
        }
        return this.setNewHistoryLike(0, this.buildHistory(0));
    }

    @Override
    public ClusterVersionStatusFluent.HistoryNested<A> editLastHistory() {
        int index = this.history.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last history. The list is empty.");
        }
        return this.setNewHistoryLike(index, this.buildHistory(index));
    }

    @Override
    public ClusterVersionStatusFluent.HistoryNested<A> editMatchingHistory(Predicate<UpdateHistoryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.history.size(); ++i) {
            if (!predicate.test(this.history.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching history. No match found.");
        }
        return this.setNewHistoryLike(index, this.buildHistory(index));
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public String getVersionHash() {
        return this.versionHash;
    }

    @Override
    public A withVersionHash(String versionHash) {
        this.versionHash = versionHash;
        return (A)this;
    }

    @Override
    public Boolean hasVersionHash() {
        return this.versionHash != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterVersionStatusFluentImpl that = (ClusterVersionStatusFluentImpl)o;
        if (this.availableUpdates != null ? !this.availableUpdates.equals(that.availableUpdates) : that.availableUpdates != null) {
            return false;
        }
        if (this.conditionalUpdates != null ? !this.conditionalUpdates.equals(that.conditionalUpdates) : that.conditionalUpdates != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.desired != null ? !this.desired.equals(that.desired) : that.desired != null) {
            return false;
        }
        if (this.history != null ? !this.history.equals(that.history) : that.history != null) {
            return false;
        }
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        if (this.versionHash != null ? !this.versionHash.equals(that.versionHash) : that.versionHash != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.availableUpdates, this.conditionalUpdates, this.conditions, this.desired, this.history, this.observedGeneration, this.versionHash, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availableUpdates != null && !this.availableUpdates.isEmpty()) {
            sb.append("availableUpdates:");
            sb.append(this.availableUpdates + ",");
        }
        if (this.conditionalUpdates != null && !this.conditionalUpdates.isEmpty()) {
            sb.append("conditionalUpdates:");
            sb.append(this.conditionalUpdates + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.desired != null) {
            sb.append("desired:");
            sb.append(this.desired + ",");
        }
        if (this.history != null && !this.history.isEmpty()) {
            sb.append("history:");
            sb.append(this.history + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.versionHash != null) {
            sb.append("versionHash:");
            sb.append(this.versionHash + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class HistoryNestedImpl<N>
    extends UpdateHistoryFluentImpl<ClusterVersionStatusFluent.HistoryNested<N>>
    implements ClusterVersionStatusFluent.HistoryNested<N>,
    Nested<N> {
        UpdateHistoryBuilder builder;
        Integer index;

        HistoryNestedImpl(Integer index, UpdateHistory item) {
            this.index = index;
            this.builder = new UpdateHistoryBuilder(this, item);
        }

        HistoryNestedImpl() {
            this.index = -1;
            this.builder = new UpdateHistoryBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterVersionStatusFluentImpl.this.setToHistory(this.index, this.builder.build());
        }

        @Override
        public N endHistory() {
            return this.and();
        }
    }

    class DesiredNestedImpl<N>
    extends ReleaseFluentImpl<ClusterVersionStatusFluent.DesiredNested<N>>
    implements ClusterVersionStatusFluent.DesiredNested<N>,
    Nested<N> {
        ReleaseBuilder builder;

        DesiredNestedImpl(Release item) {
            this.builder = new ReleaseBuilder(this, item);
        }

        DesiredNestedImpl() {
            this.builder = new ReleaseBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterVersionStatusFluentImpl.this.withDesired(this.builder.build());
        }

        @Override
        public N endDesired() {
            return this.and();
        }
    }

    class ConditionsNestedImpl<N>
    extends ClusterOperatorStatusConditionFluentImpl<ClusterVersionStatusFluent.ConditionsNested<N>>
    implements ClusterVersionStatusFluent.ConditionsNested<N>,
    Nested<N> {
        ClusterOperatorStatusConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, ClusterOperatorStatusCondition item) {
            this.index = index;
            this.builder = new ClusterOperatorStatusConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ClusterOperatorStatusConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterVersionStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    class ConditionalUpdatesNestedImpl<N>
    extends ConditionalUpdateFluentImpl<ClusterVersionStatusFluent.ConditionalUpdatesNested<N>>
    implements ClusterVersionStatusFluent.ConditionalUpdatesNested<N>,
    Nested<N> {
        ConditionalUpdateBuilder builder;
        Integer index;

        ConditionalUpdatesNestedImpl(Integer index, ConditionalUpdate item) {
            this.index = index;
            this.builder = new ConditionalUpdateBuilder(this, item);
        }

        ConditionalUpdatesNestedImpl() {
            this.index = -1;
            this.builder = new ConditionalUpdateBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterVersionStatusFluentImpl.this.setToConditionalUpdates(this.index, this.builder.build());
        }

        @Override
        public N endConditionalUpdate() {
            return this.and();
        }
    }

    class AvailableUpdatesNestedImpl<N>
    extends ReleaseFluentImpl<ClusterVersionStatusFluent.AvailableUpdatesNested<N>>
    implements ClusterVersionStatusFluent.AvailableUpdatesNested<N>,
    Nested<N> {
        ReleaseBuilder builder;
        Integer index;

        AvailableUpdatesNestedImpl(Integer index, Release item) {
            this.index = index;
            this.builder = new ReleaseBuilder(this, item);
        }

        AvailableUpdatesNestedImpl() {
            this.index = -1;
            this.builder = new ReleaseBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterVersionStatusFluentImpl.this.setToAvailableUpdates(this.index, this.builder.build());
        }

        @Override
        public N endAvailableUpdate() {
            return this.and();
        }
    }
}

