/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;

public class HasMetadataOperationsImpl<T extends HasMetadata, L extends KubernetesResourceList<T>>
extends HasMetadataOperation<T, L, Resource<T>>
implements MixedOperation<T, L, Resource<T>> {
    protected final ResourceDefinitionContext rdc;

    public HasMetadataOperationsImpl(Client client, ResourceDefinitionContext rdc, Class<T> type, Class<L> listType) {
        this(HasMetadataOperationsImpl.defaultContext(client), rdc, type, listType);
    }

    public static OperationContext defaultContext(Client client) {
        return (OperationContext)Utils.getNonNullOrElse((Object)((BaseClient)client.adapt(BaseClient.class)).getOperationContext(), (Object)new OperationContext().withClient(client).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
    }

    public HasMetadataOperationsImpl(OperationContext context, ResourceDefinitionContext rdc, Class<T> type, Class<L> listType) {
        super(context.withApiGroupName(rdc.getGroup()).withApiGroupVersion(rdc.getVersion()).withPlural(rdc.getPlural()), type, listType != null ? listType : KubernetesResourceUtil.inferListType(type));
        this.rdc = rdc;
        if (!GenericKubernetesResource.class.isAssignableFrom(type)) {
            KubernetesDeserializer.registerCustomKind(this.apiVersion, this.kind(rdc), type);
            if (KubernetesResource.class.isAssignableFrom(this.listType)) {
                KubernetesDeserializer.registerCustomKind(this.listType.getSimpleName(), this.listType);
            }
        }
    }

    @Override
    public HasMetadataOperationsImpl<T, L> newInstance(OperationContext context) {
        return new HasMetadataOperationsImpl<T, L>(context, this.rdc, this.type, this.listType);
    }

    private String kind(ResourceDefinitionContext context) {
        return context.getKind() != null ? context.getKind() : this.getKind();
    }

    @Override
    public boolean isResourceNamespaced() {
        return this.rdc.isNamespaceScoped();
    }

    public OperationContext getOperationContext() {
        return this.context;
    }
}

