/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.APIServerConfig;
import io.fabric8.openshift.api.model.monitoring.v1.APIServerConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.APIServerConfigFluentImpl;
import java.util.Objects;

public class APIServerConfigBuilder
extends APIServerConfigFluentImpl<APIServerConfigBuilder>
implements VisitableBuilder<APIServerConfig, APIServerConfigBuilder> {
    APIServerConfigFluent<?> fluent;
    Boolean validationEnabled;

    public APIServerConfigBuilder() {
        this(false);
    }

    public APIServerConfigBuilder(Boolean validationEnabled) {
        this(new APIServerConfig(), validationEnabled);
    }

    public APIServerConfigBuilder(APIServerConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public APIServerConfigBuilder(APIServerConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new APIServerConfig(), validationEnabled);
    }

    public APIServerConfigBuilder(APIServerConfigFluent<?> fluent, APIServerConfig instance) {
        this(fluent, instance, false);
    }

    public APIServerConfigBuilder(APIServerConfigFluent<?> fluent, APIServerConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBasicAuth(instance.getBasicAuth());
        fluent.withBearerToken(instance.getBearerToken());
        fluent.withBearerTokenFile(instance.getBearerTokenFile());
        fluent.withHost(instance.getHost());
        fluent.withTlsConfig(instance.getTlsConfig());
        this.validationEnabled = validationEnabled;
    }

    public APIServerConfigBuilder(APIServerConfig instance) {
        this(instance, (Boolean)false);
    }

    public APIServerConfigBuilder(APIServerConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBasicAuth(instance.getBasicAuth());
        this.withBearerToken(instance.getBearerToken());
        this.withBearerTokenFile(instance.getBearerTokenFile());
        this.withHost(instance.getHost());
        this.withTlsConfig(instance.getTlsConfig());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public APIServerConfig build() {
        APIServerConfig buildable = new APIServerConfig(this.fluent.getBasicAuth(), this.fluent.getBearerToken(), this.fluent.getBearerTokenFile(), this.fluent.getHost(), this.fluent.getTlsConfig());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIServerConfigBuilder that = (APIServerConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

