/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.CustomTLSProfile;
import io.fabric8.openshift.api.model.CustomTLSProfileFluent;
import io.fabric8.openshift.api.model.CustomTLSProfileFluentImpl;
import java.util.Objects;

public class CustomTLSProfileBuilder
extends CustomTLSProfileFluentImpl<CustomTLSProfileBuilder>
implements VisitableBuilder<CustomTLSProfile, CustomTLSProfileBuilder> {
    CustomTLSProfileFluent<?> fluent;
    Boolean validationEnabled;

    public CustomTLSProfileBuilder() {
        this(false);
    }

    public CustomTLSProfileBuilder(Boolean validationEnabled) {
        this(new CustomTLSProfile(), validationEnabled);
    }

    public CustomTLSProfileBuilder(CustomTLSProfileFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public CustomTLSProfileBuilder(CustomTLSProfileFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CustomTLSProfile(), validationEnabled);
    }

    public CustomTLSProfileBuilder(CustomTLSProfileFluent<?> fluent, CustomTLSProfile instance) {
        this(fluent, instance, false);
    }

    public CustomTLSProfileBuilder(CustomTLSProfileFluent<?> fluent, CustomTLSProfile instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCiphers(instance.getCiphers());
        fluent.withMinTLSVersion(instance.getMinTLSVersion());
        this.validationEnabled = validationEnabled;
    }

    public CustomTLSProfileBuilder(CustomTLSProfile instance) {
        this(instance, (Boolean)false);
    }

    public CustomTLSProfileBuilder(CustomTLSProfile instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCiphers(instance.getCiphers());
        this.withMinTLSVersion(instance.getMinTLSVersion());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public CustomTLSProfile build() {
        CustomTLSProfile buildable = new CustomTLSProfile(this.fluent.getCiphers(), this.fluent.getMinTLSVersion());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomTLSProfileBuilder that = (CustomTLSProfileBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

