/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.informers.ListerWatcher;
import io.fabric8.kubernetes.client.informers.cache.SyncableStore;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reflector<T extends HasMetadata, L extends KubernetesResourceList<T>> {
    private static final Logger log = LoggerFactory.getLogger(Reflector.class);
    private volatile String lastSyncResourceVersion;
    private final Class<T> apiTypeClass;
    private final ListerWatcher<T, L> listerWatcher;
    private final SyncableStore<T> store;
    private final ReflectorWatcher watcher;
    private volatile boolean running;
    private volatile boolean watching;
    private final AtomicReference<Watch> watch;

    public Reflector(Class<T> apiTypeClass, ListerWatcher<T, L> listerWatcher, SyncableStore<T> store) {
        this.apiTypeClass = apiTypeClass;
        this.listerWatcher = listerWatcher;
        this.store = store;
        this.watcher = new ReflectorWatcher();
        this.watch = new AtomicReference<Object>(null);
    }

    protected L getList() {
        return (L)((KubernetesResourceList)this.listerWatcher.list());
    }

    public void stop() {
        this.running = false;
        this.stopWatcher();
    }

    private synchronized void stopWatcher() {
        Watch theWatch = this.watch.getAndSet(null);
        if (theWatch != null) {
            String ns = this.listerWatcher.getNamespace();
            log.debug("Stopping watcher for resource {} v{} in namespace {}", new Object[]{this.apiTypeClass, this.lastSyncResourceVersion, ns});
            theWatch.close();
            this.watchStopped();
        }
    }

    public void listSyncAndWatch() {
        String latestResourceVersion;
        this.running = true;
        L list = this.getList();
        this.lastSyncResourceVersion = latestResourceVersion = list.getMetadata().getResourceVersion();
        log.debug("Listing items ({}) for resource {} v{}", new Object[]{list.getItems().size(), this.apiTypeClass, latestResourceVersion});
        this.store.replace(list.getItems());
        this.startWatcher(latestResourceVersion);
    }

    private synchronized void startWatcher(String latestResourceVersion) {
        if (!this.running) {
            return;
        }
        log.debug("Starting watcher for resource {} v{}", this.apiTypeClass, (Object)latestResourceVersion);
        this.watch.set(this.listerWatcher.watch(((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion(latestResourceVersion)).withTimeoutSeconds(null)).build(), this.watcher));
        this.watching = true;
    }

    private synchronized void watchStopped() {
        this.watching = false;
    }

    public String getLastSyncResourceVersion() {
        return this.lastSyncResourceVersion;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isWatching() {
        return this.watching;
    }

    public ReflectorWatcher getWatcher() {
        return this.watcher;
    }

    class ReflectorWatcher
    implements Watcher<T> {
        ReflectorWatcher() {
        }

        @Override
        public void eventReceived(Watcher.Action action, T resource) {
            if (action == null) {
                throw new KubernetesClientException("Unrecognized event");
            }
            if (resource == null) {
                throw new KubernetesClientException("Unrecognized resource");
            }
            if (log.isDebugEnabled()) {
                log.debug("Event received {} {}# resourceVersion {}", new Object[]{action.name(), resource.getKind(), resource.getMetadata().getResourceVersion()});
            }
            switch (action) {
                case ERROR: {
                    throw new KubernetesClientException("ERROR event");
                }
                case ADDED: {
                    Reflector.this.store.add(resource);
                    break;
                }
                case MODIFIED: {
                    Reflector.this.store.update(resource);
                    break;
                }
                case DELETED: {
                    Reflector.this.store.delete(resource);
                }
            }
            Reflector.this.lastSyncResourceVersion = resource.getMetadata().getResourceVersion();
        }

        @Override
        public void onClose(WatcherException exception) {
            boolean restarted = false;
            try {
                if (exception.isHttpGone()) {
                    log.debug("Watch restarting due to http gone");
                    Reflector.this.listSyncAndWatch();
                    restarted = true;
                } else {
                    log.warn("Watch closing with exception", (Throwable)exception);
                    Reflector.this.running = false;
                }
            }
            finally {
                if (!restarted) {
                    Reflector.this.watchStopped();
                }
            }
        }

        @Override
        public void onClose() {
            Reflector.this.watchStopped();
            log.debug("Watch gracefully closed");
        }

        @Override
        public boolean reconnecting() {
            return true;
        }
    }
}

