/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogCategoryMeta;
import io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogCategoryMetaFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class DeveloperConsoleCatalogCategoryMetaFluentImpl<A extends DeveloperConsoleCatalogCategoryMetaFluent<A>>
extends BaseFluent<A>
implements DeveloperConsoleCatalogCategoryMetaFluent<A> {
    private String id;
    private String label;
    private List<String> tags = new ArrayList<String>();

    public DeveloperConsoleCatalogCategoryMetaFluentImpl() {
    }

    public DeveloperConsoleCatalogCategoryMetaFluentImpl(DeveloperConsoleCatalogCategoryMeta instance) {
        this.withId(instance.getId());
        this.withLabel(instance.getLabel());
        this.withTags(instance.getTags());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public A withId(String id) {
        this.id = id;
        return (A)this;
    }

    @Override
    public Boolean hasId() {
        return this.id != null;
    }

    @Override
    @Deprecated
    public A withNewId(String arg0) {
        return this.withId(new String(arg0));
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public A withLabel(String label) {
        this.label = label;
        return (A)this;
    }

    @Override
    public Boolean hasLabel() {
        return this.label != null;
    }

    @Override
    @Deprecated
    public A withNewLabel(String arg0) {
        return this.withLabel(new String(arg0));
    }

    @Override
    public A addToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTags(String ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTags(Collection<String> items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTags(String ... items) {
        for (String item : items) {
            if (this.tags == null) continue;
            this.tags.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTags(Collection<String> items) {
        for (String item : items) {
            if (this.tags == null) continue;
            this.tags.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public String getTag(int index) {
        return this.tags.get(index);
    }

    @Override
    public String getFirstTag() {
        return this.tags.get(0);
    }

    @Override
    public String getLastTag() {
        return this.tags.get(this.tags.size() - 1);
    }

    @Override
    public String getMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTags(List<String> tags) {
        if (this.tags != null) {
            this._visitables.get("tags").removeAll(this.tags);
        }
        if (tags != null) {
            this.tags = new ArrayList<String>();
            for (String item : tags) {
                this.addToTags(item);
            }
        } else {
            this.tags = null;
        }
        return (A)this;
    }

    @Override
    public A withTags(String ... tags) {
        if (this.tags != null) {
            this.tags.clear();
        }
        if (tags != null) {
            for (String item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    @Override
    public A addNewTag(String arg0) {
        return this.addToTags(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeveloperConsoleCatalogCategoryMetaFluentImpl that = (DeveloperConsoleCatalogCategoryMetaFluentImpl)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
            return false;
        }
        return !(this.tags != null ? !this.tags.equals(that.tags) : that.tags != null);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.label, this.tags, super.hashCode());
    }
}

