/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.autoscaling.v1.Scale;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.utils.PodOperationUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobOperationsImpl
extends HasMetadataOperation<Job, JobList, ScalableResource<Job>>
implements ScalableResource<Job> {
    static final transient Logger LOG = LoggerFactory.getLogger(JobOperationsImpl.class);
    private Integer podLogWaitTimeout;

    public JobOperationsImpl(OkHttpClient client, Config config) {
        this(client, config, null);
    }

    public JobOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
    }

    public JobOperationsImpl(OperationContext context) {
        super(context.withApiGroupName("batch").withApiGroupVersion("v1").withPlural("jobs"));
        this.type = Job.class;
        this.listType = JobList.class;
    }

    private JobOperationsImpl(OperationContext context, Integer podLogWaitTimeout) {
        this(context);
        this.podLogWaitTimeout = podLogWaitTimeout;
    }

    public JobOperationsImpl newInstance(OperationContext context) {
        return new JobOperationsImpl(context);
    }

    @Override
    public ScalableResource<Job> load(InputStream is) {
        try {
            Job item = JobOperationsImpl.unmarshal(is, Job.class);
            return new JobOperationsImpl(this.context.withItem(item));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public ScalableResource<Job> fromServer() {
        return new JobOperationsImpl(this.context.withReloadingFromServer(true));
    }

    @Override
    public Job scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public Scale scale() {
        return this.handleScale(null);
    }

    @Override
    public Scale scale(Scale scale) {
        return this.handleScale(scale);
    }

    @Override
    public Job scale(int count, boolean wait) {
        Job res = (Job)this.accept(b -> b.getSpec().setParallelism(count));
        if (wait) {
            this.waitUntilJobIsScaled();
            res = (Job)this.getMandatory();
        }
        return res;
    }

    private void waitUntilJobIsScaled() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference atomicJob = new AtomicReference();
        Runnable jobPoller = () -> {
            try {
                Job job = (Job)this.getMandatory();
                atomicJob.set(job);
                Integer activeJobs = job.getStatus().getActive();
                if (activeJobs == null) {
                    activeJobs = 0;
                }
                if (Objects.equals(job.getSpec().getParallelism(), activeJobs)) {
                    countDownLatch.countDown();
                } else {
                    LOG.debug("Only {}/{} pods scheduled for Job: {} in namespace: {} seconds so waiting...", new Object[]{job.getStatus().getActive(), job.getSpec().getParallelism(), job.getMetadata().getName(), this.namespace});
                }
            }
            catch (Throwable t) {
                LOG.error("Error while waiting for Job to be scaled.", t);
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(jobPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            countDownLatch.await(this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS);
            executor.shutdown();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            poller.cancel(true);
            executor.shutdown();
            LOG.error("Only {}/{} pod(s) ready for Job: {} in namespace: {} - giving up", new Object[]{((Job)atomicJob.get()).getStatus().getActive(), ((Job)atomicJob.get()).getSpec().getParallelism(), ((Job)atomicJob.get()).getMetadata().getName(), this.namespace});
        }
    }

    @Override
    public String getLog() {
        return this.getLog(false);
    }

    @Override
    public String getLog(Boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<PodResource<Pod>> podOperationList = this.doGetLog(false);
        for (PodResource<Pod> podOperation : podOperationList) {
            stringBuilder.append(podOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<PodResource<Pod>> doGetLog(boolean isPretty) {
        Job job = (Job)this.requireFromServer();
        return PodOperationUtil.getPodOperationsForController(this.context, job.getMetadata().getUid(), JobOperationsImpl.getJobPodLabels(job), isPretty, this.podLogWaitTimeout);
    }

    @Override
    public Reader getLogReader() {
        List<PodResource<Pod>> podResources = this.doGetLog(false);
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Reading logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return podResources.get(0).getLogReader();
        }
        return null;
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        List<PodResource<Pod>> podResources = this.doGetLog(false);
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Watching logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return (LogWatch)podResources.get(0).watchLog(out);
        }
        return null;
    }

    @Override
    public Loggable<LogWatch> withLogWaitTimeout(Integer logWaitTimeout) {
        return new JobOperationsImpl(this.context, logWaitTimeout);
    }

    @Override
    public Job replace(Job job) {
        if (job == null) {
            job = (Job)this.getItem();
        }
        Job jobFromServer = (Job)this.requireFromServer();
        if (job.getSpec().getSelector() == null) {
            job.getSpec().setSelector(jobFromServer.getSpec().getSelector());
        }
        if (job.getSpec().getTemplate().getMetadata() != null) {
            job.getSpec().getTemplate().getMetadata().setLabels(jobFromServer.getSpec().getTemplate().getMetadata().getLabels());
        } else {
            job.getSpec().getTemplate().setMetadata(jobFromServer.getSpec().getTemplate().getMetadata());
        }
        return super.replace(job);
    }

    @Override
    protected VisitableBuilder<Job, ?> createVisitableBuilder(Job item) {
        return new JobBuilder(item);
    }

    static Map<String, String> getJobPodLabels(Job job) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (job != null && job.getMetadata() != null && job.getMetadata().getUid() != null) {
            labels.put("controller-uid", job.getMetadata().getUid());
        }
        return labels;
    }
}

