/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.client.dsl.internal.RawRequestBuilder;
import io.fabric8.kubernetes.client.dsl.internal.WatcherWebSocketListener;
import io.fabric8.kubernetes.client.dsl.internal.WebSocketClientRunner;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;

public class RawWatchConnectionManager
extends AbstractWatchManager<String> {
    public RawWatchConnectionManager(final OkHttpClient okHttpClient, HttpUrl.Builder watchUrlBuilder, ListOptions listOptions, final ObjectMapper objectMapper, Watcher<String> watcher, int reconnectLimit, int reconnectInterval, int maxIntervalExponent) {
        super(watcher, listOptions, reconnectLimit, reconnectInterval, maxIntervalExponent, new RawRequestBuilder(watchUrlBuilder));
        this.initRunner(new WebSocketClientRunner<String>(okHttpClient){

            @Override
            WatcherWebSocketListener<String> newListener(BlockingQueue<Object> queue, AtomicReference<WebSocket> webSocketRef) {
                return new RawWatcherWebSocketListener(RawWatchConnectionManager.this, queue, webSocketRef, objectMapper);
            }

            @Override
            OkHttpClient cloneAndCustomize(OkHttpClient client) {
                return okHttpClient.newBuilder().build();
            }
        });
        this.runWatch();
    }

    private static class RawWatcherWebSocketListener
    extends WatcherWebSocketListener<String> {
        private final ObjectMapper objectMapper;

        public RawWatcherWebSocketListener(AbstractWatchManager<String> manager, BlockingQueue<Object> queue, AtomicReference<WebSocket> webSocketRef, ObjectMapper objectMapper) {
            super(manager, queue, webSocketRef);
            this.objectMapper = objectMapper;
        }

        public void onMessage(WebSocket webSocket, String text) {
            try {
                Map watchEvent = (Map)this.objectMapper.readValue(text, HashMap.class);
                String watchEventType = watchEvent.get("type").toString();
                String watchObjectAsString = this.objectMapper.writeValueAsString(watchEvent.get("object"));
                this.manager.eventReceived(Watcher.Action.valueOf(watchEventType), watchObjectAsString);
            }
            catch (IOException exception) {
                logger.error("Failed to deserialize watch response: " + exception.getMessage());
            }
        }
    }
}

