/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.DeleteOptions;
import io.fabric8.kubernetes.api.model.DeleteOptionsBuilder;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.GracePeriodConfigurable;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.PropagationPolicyConfigurable;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.DryRunable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.Namespaceable;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.client.dsl.internal.RawWatchConnectionManager;
import io.fabric8.kubernetes.client.internal.PatchUtils;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.IOHelpers;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.client.utils.WatcherToggle;
import io.fabric8.zjsonpatch.JsonDiff;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class RawCustomResourceOperationsImpl
extends OperationSupport
implements Nameable<RawCustomResourceOperationsImpl>,
Namespaceable<RawCustomResourceOperationsImpl>,
AnyNamespaceable<RawCustomResourceOperationsImpl>,
Listable<Map<String, Object>>,
Gettable<Map<String, Object>>,
GracePeriodConfigurable<RawCustomResourceOperationsImpl>,
PropagationPolicyConfigurable<RawCustomResourceOperationsImpl>,
DryRunable<RawCustomResourceOperationsImpl>,
Deletable {
    private static final String METADATA = "metadata";
    private static final String RESOURCE_VERSION = "resourceVersion";
    private static final String STATUS_SUBRESOURCE_ENDPOINT = "/status";
    private final CustomResourceDefinitionContext customResourceDefinition;
    private final ObjectMapper objectMapper;
    private final ListOptions listOptions;
    private final long gracePeriodInSeconds;
    private final String deletionPropagation;
    private final boolean cascading;

    private RawCustomResourceOperationsImpl(OkHttpClient client, Config config, CustomResourceDefinitionContext crdContext, String namespace, String name, long gracePeriodInSeconds, boolean cascading, String deletionPropagation, ListOptions listOptions, boolean dryRun) {
        super(client, config);
        this.customResourceDefinition = crdContext;
        this.objectMapper = PatchUtils.patchMapper();
        this.namespace = namespace;
        this.name = name;
        this.gracePeriodInSeconds = gracePeriodInSeconds;
        this.cascading = cascading;
        this.deletionPropagation = deletionPropagation;
        this.listOptions = listOptions;
        this.dryRun = dryRun;
    }

    public RawCustomResourceOperationsImpl(OkHttpClient client, Config config, CustomResourceDefinitionContext customResourceDefinition) {
        this(client, config, customResourceDefinition, null, null, 0L, false, DeletionPropagation.BACKGROUND.toString(), null, false);
    }

    @Override
    public RawCustomResourceOperationsImpl withName(String name) {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, this.namespace, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun);
    }

    @Override
    public RawCustomResourceOperationsImpl inNamespace(String namespace) {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, this.name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun);
    }

    @Override
    public RawCustomResourceOperationsImpl inAnyNamespace() {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, null, this.name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun);
    }

    @Override
    public RawCustomResourceOperationsImpl withGracePeriod(long gracePeriodSeconds) {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, this.namespace, this.name, gracePeriodSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun);
    }

    @Override
    public RawCustomResourceOperationsImpl withPropagationPolicy(DeletionPropagation propagationPolicy) {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, this.namespace, this.name, this.gracePeriodInSeconds, this.cascading, propagationPolicy.toString(), this.listOptions, this.dryRun);
    }

    @Override
    public RawCustomResourceOperationsImpl dryRun(boolean isDryRun) {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, this.namespace, this.name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, isDryRun);
    }

    public Map<String, Object> load(InputStream fileInputStream) throws IOException {
        return this.convertJsonOrYamlStringToMap(IOHelpers.readFully(fileInputStream));
    }

    public Map<String, Object> load(String objectAsJsonString) throws IOException {
        return this.convertJsonOrYamlStringToMap(objectAsJsonString);
    }

    public Map<String, Object> create(String objectAsString) throws IOException {
        return this.validateAndSubmitRequest(objectAsString, HttpCallMethod.POST);
    }

    public Map<String, Object> create(Map<String, Object> object) throws IOException {
        return this.validateAndSubmitRequest(this.objectMapper.writeValueAsString(object), HttpCallMethod.POST);
    }

    public Map<String, Object> create(String namespace, String objectAsString) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, null, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).create(objectAsString);
    }

    public Map<String, Object> create(InputStream objectAsStream) throws IOException {
        return this.validateAndSubmitRequest(IOHelpers.readFully(objectAsStream), HttpCallMethod.POST);
    }

    public Map<String, Object> create(String namespace, InputStream objectAsStream) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, null, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).create(objectAsStream);
    }

    public Map<String, Object> create(String namespace, Map<String, Object> object) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, null, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).create(object);
    }

    public Map<String, Object> createOrReplace(String objectAsString) throws IOException {
        return this.createOrReplaceObject(this.load(objectAsString));
    }

    public Map<String, Object> createOrReplace(Map<String, Object> customResourceObject) throws IOException {
        return this.createOrReplaceObject(customResourceObject);
    }

    public Map<String, Object> createOrReplace(InputStream inputStream) throws IOException {
        return this.createOrReplaceObject(this.load(inputStream));
    }

    public Map<String, Object> createOrReplace(String namespace, String objectAsString) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, null, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).createOrReplace(objectAsString);
    }

    public Map<String, Object> createOrReplace(String namespace, Map<String, Object> customResourceObject) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, null, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).createOrReplace(customResourceObject);
    }

    public Map<String, Object> createOrReplace(String namespace, InputStream objectAsStream) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, null, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).createOrReplace(objectAsStream);
    }

    private Map<String, Object> replace(String namespace, String name, Map<String, Object> object) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).replace(object);
    }

    private Map<String, Object> replace(String name, Map<String, Object> object) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, null, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).replace(object);
    }

    private Map<String, Object> replace(Map<String, Object> object) throws IOException {
        return this.validateAndSubmitRequest(this.objectMapper.writeValueAsString(object), HttpCallMethod.PUT);
    }

    public Map<String, Object> edit(String name, Map<String, Object> object) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, null, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).edit(object);
    }

    public Map<String, Object> edit(String name, String objectAsString) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, null, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).edit(objectAsString);
    }

    public Map<String, Object> edit(String namespace, String name, Map<String, Object> object) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).edit(object);
    }

    public Map<String, Object> edit(String namespace, String name, String objectAsString) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).edit(objectAsString);
    }

    public Map<String, Object> edit(String objectAsString) throws IOException {
        Map<String, Object> object = this.convertJsonOrYamlStringToMap(objectAsString);
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, this.namespace, this.name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).edit(object);
    }

    public Map<String, Object> edit(Map<String, Object> object) throws IOException {
        String objectAsString = this.getPatchDiff(this.namespace, this.name, object);
        return this.validateAndSubmitRequest(objectAsString, HttpCallMethod.PATCH);
    }

    public Map<String, Object> updateStatus(String name, Map<String, Object> objectAsMap) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, null, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).updateStatus(objectAsMap);
    }

    public Map<String, Object> updateStatus(String name, String objectAsJsonString) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, null, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).updateStatus(objectAsJsonString);
    }

    public Map<String, Object> updateStatus(String namespace, String name, Map<String, Object> objectAsMap) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).updateStatus(objectAsMap);
    }

    public Map<String, Object> updateStatus(String name, InputStream objectAsStream) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, null, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).updateStatus(objectAsStream);
    }

    public Map<String, Object> updateStatus(String namespace, String name, InputStream objectAsStream) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).updateStatus(objectAsStream);
    }

    public Map<String, Object> updateStatus(String namespace, String name, String objectAsJsonString) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).updateStatus(objectAsJsonString);
    }

    public Map<String, Object> updateStatus(String objectAsJsonString) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(null) + STATUS_SUBRESOURCE_ENDPOINT, objectAsJsonString, HttpCallMethod.PUT);
    }

    public Map<String, Object> updateStatus(Map<String, Object> objectAsMap) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(null) + STATUS_SUBRESOURCE_ENDPOINT, this.objectMapper.writeValueAsString(objectAsMap), HttpCallMethod.PUT);
    }

    public Map<String, Object> updateStatus(InputStream objectAsInputStream) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(null) + STATUS_SUBRESOURCE_ENDPOINT, IOHelpers.readFully(objectAsInputStream), HttpCallMethod.PUT);
    }

    @Override
    public Map<String, Object> get() {
        return this.makeCall(this.fetchUrl(null), null, HttpCallMethod.GET);
    }

    public Map<String, Object> get(String name) {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, null, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).get();
    }

    public Map<String, Object> get(String namespace, String name) {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).get();
    }

    @Override
    public Map<String, Object> list() {
        return this.makeCall(this.fetchUrl(null), null, HttpCallMethod.GET);
    }

    @Override
    public Map<String, Object> list(Integer limitVal, String continueVal) {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, this.namespace, this.name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, ((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(limitVal.longValue())).withContinue(continueVal)).build(), this.dryRun).list();
    }

    @Override
    public Map<String, Object> list(ListOptions listOptions) {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, this.namespace, this.name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, listOptions, this.dryRun).list();
    }

    public Map<String, Object> list(String namespace) {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, null, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).list();
    }

    public Map<String, Object> list(String namespace, Map<String, String> labels) {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, null, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, ((ListOptionsBuilder)new ListOptionsBuilder().withLabelSelector(this.getLabelsQueryParam(labels))).build(), this.dryRun).list();
    }

    public boolean delete(String namespaceOrName) {
        return this.pickNamespaceOrNameBasedOnScopeAndDelete(namespaceOrName, null);
    }

    public boolean delete(String namespaceOrName, boolean cascading) throws IOException {
        return this.pickNamespaceOrNameBasedOnScopeAndDelete(namespaceOrName, this.objectMapper.writeValueAsString((Object)this.fetchDeleteOptions(cascading, null)));
    }

    public boolean delete(String namespaceOrName, DeleteOptions deleteOptions) throws IOException {
        return this.pickNamespaceOrNameBasedOnScopeAndDelete(namespaceOrName, this.objectMapper.writeValueAsString((Object)deleteOptions));
    }

    public boolean delete(String namespace, String name) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).delete();
    }

    public boolean delete(String namespace, String name, boolean cascading) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, name, this.gracePeriodInSeconds, cascading, null, this.listOptions, this.dryRun).delete();
    }

    public boolean delete(String namespace, String name, String propagationPolicy) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, name, this.gracePeriodInSeconds, this.cascading, propagationPolicy, this.listOptions, this.dryRun).delete();
    }

    public boolean delete(String namespace, String name, DeleteOptions deleteOptions) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).handleDelete(this.objectMapper.writeValueAsString((Object)deleteOptions));
    }

    @Override
    public Boolean delete() {
        try {
            return this.handleDelete(this.objectMapper.writeValueAsString((Object)this.fetchDeleteOptions(this.cascading, null)));
        }
        catch (JsonProcessingException jpe) {
            throw KubernetesClientException.launderThrowable(jpe);
        }
    }

    public void watch(String namespace, Watcher<String> watcher) throws IOException {
        this.watch(namespace, null, null, new ListOptionsBuilder().build(), watcher);
    }

    public void watch(String namespace, String resourceVersion, Watcher<String> watcher) throws IOException {
        this.watch(namespace, null, null, ((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion(resourceVersion)).build(), watcher);
    }

    public void watch(String namespace, ListOptions options, Watcher<String> watcher) throws IOException {
        this.watch(namespace, null, null, options, watcher);
    }

    public void watch(Watcher<String> watcher) throws IOException {
        this.watch(null, null, null, new ListOptionsBuilder().build(), watcher);
    }

    public Watch watch(String namespace, String name, Map<String, String> labels, String resourceVersion, Watcher<String> watcher) throws IOException {
        return this.watch(namespace, name, labels, ((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion(resourceVersion)).build(), watcher);
    }

    public Watch watch(String namespace, String name, Map<String, String> labels, ListOptions options, Watcher<String> watcher) throws IOException {
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, namespace, name, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).watch(labels, options, watcher);
    }

    public Watch watch(Map<String, String> labels, ListOptions options, Watcher<String> watcher) throws IOException {
        if (options == null) {
            options = new ListOptions();
        }
        options.setWatch(true);
        HttpUrl.Builder watchUrlBuilder = this.fetchWatchUrl(labels, options);
        OkHttpClient.Builder clonedClientBuilder = this.client.newBuilder();
        clonedClientBuilder.readTimeout(this.getConfig() != null ? this.getConfig().getWebsocketTimeout() : Config.DEFAULT_WEBSOCKET_TIMEOUT.longValue(), TimeUnit.MILLISECONDS);
        clonedClientBuilder.pingInterval(this.getConfig() != null ? this.getConfig().getWebsocketPingInterval() : Config.DEFAULT_WEBSOCKET_PING_INTERVAL.longValue(), TimeUnit.MILLISECONDS);
        OkHttpClient clonedOkHttpClient = clonedClientBuilder.build();
        WatcherToggle<String> watcherToggle = new WatcherToggle<String>(watcher, true);
        AbstractWatchManager watch = null;
        try {
            watch = new RawWatchConnectionManager(clonedOkHttpClient, watchUrlBuilder, options, this.objectMapper, watcher, this.getConfig() != null ? this.getConfig().getWatchReconnectLimit() : -1, this.getConfig() != null ? this.getConfig().getWatchReconnectInterval() : 1000, 5);
            watch.waitUntilReady();
            return watch;
        }
        catch (KubernetesClientException ke) {
            if (ke.getCode() != 200) {
                if (watch != null) {
                    watch.close();
                }
                throw ke;
            }
            if (watch != null) {
                watcherToggle.disable();
                watch.close();
            }
            return new RawWatchConnectionManager(clonedOkHttpClient, watchUrlBuilder, options, this.objectMapper, watcher, this.getConfig() != null ? this.getConfig().getWatchReconnectLimit() : -1, this.getConfig() != null ? this.getConfig().getWatchReconnectInterval() : 1000, 5);
        }
    }

    private Map<String, Object> createOrReplaceObject(Map<String, Object> objectAsMap) throws IOException {
        Map<String, Object> ret;
        Map metadata = (Map)objectAsMap.get(METADATA);
        if (metadata == null) {
            throw KubernetesClientException.launderThrowable(new IllegalStateException("Invalid object provided -- metadata is required."));
        }
        String originalResourceVersion = (String)metadata.get(RESOURCE_VERSION);
        metadata.remove(RESOURCE_VERSION);
        try {
            ret = this.namespace != null ? this.create(this.namespace, objectAsMap) : this.create(objectAsMap);
        }
        catch (KubernetesClientException exception) {
            if (exception.getCode() != 409) {
                throw exception;
            }
            try {
                if (originalResourceVersion != null) {
                    metadata.put(RESOURCE_VERSION, originalResourceVersion);
                }
                String nameFromObject = (String)metadata.get("name");
                ret = this.namespace != null ? this.replace(this.namespace, nameFromObject, objectAsMap) : this.replace(nameFromObject, objectAsMap);
            }
            catch (NullPointerException nullPointerException) {
                throw KubernetesClientException.launderThrowable(new IllegalStateException("Invalid object provided -- metadata.name is required."));
            }
        }
        return ret;
    }

    private Map<String, Object> convertJsonOrYamlStringToMap(String objectAsString) throws IOException {
        HashMap retVal = null;
        retVal = IOHelpers.isJSONValid(objectAsString) ? (HashMap)this.objectMapper.readValue(objectAsString, HashMap.class) : (HashMap)this.objectMapper.readValue(IOHelpers.convertYamlToJson(objectAsString), HashMap.class);
        return retVal;
    }

    protected HttpUrl.Builder fetchWatchUrl(Map<String, String> labels, ListOptions options) throws MalformedURLException {
        String configuredName = this.name;
        this.name = null;
        String resourceUrl = this.fetchUrl(labels);
        if (resourceUrl.endsWith("/")) {
            resourceUrl = resourceUrl.substring(0, resourceUrl.length() - 1);
        }
        URL url = new URL(resourceUrl);
        HttpUrl.Builder httpUrlBuilder = HttpUrl.get((URL)url).newBuilder();
        if (configuredName != null) {
            httpUrlBuilder.addQueryParameter("fieldSelector", "metadata.name=" + configuredName);
        }
        HttpClientUtils.appendListOptionParams(httpUrlBuilder, options);
        return httpUrlBuilder;
    }

    private String fetchUrl(Map<String, String> labels) {
        if (this.config.getMasterUrl() == null) {
            return null;
        }
        HttpUrl.Builder urlBuilder = HttpUrl.get((String)this.getNamespacedUrl(this.namespace, this.name)).newBuilder();
        if (labels != null) {
            urlBuilder.addQueryParameter("labelSelector", this.getLabelsQueryParam(labels));
        }
        if (this.listOptions != null) {
            urlBuilder = HttpClientUtils.appendListOptionParams(urlBuilder, this.listOptions);
        }
        if (this.dryRun) {
            urlBuilder.addQueryParameter("dryRun", "All");
        }
        return urlBuilder.toString();
    }

    private String getNamespacedUrl(String namespace, String name) {
        StringBuilder urlBuilder = new StringBuilder(this.config.getMasterUrl());
        urlBuilder.append(this.config.getMasterUrl().endsWith("/") ? "" : "/");
        if (Utils.isNotNullOrEmpty(this.customResourceDefinition.getGroup())) {
            urlBuilder.append("apis/");
            urlBuilder.append(this.customResourceDefinition.getGroup()).append("/");
        } else {
            urlBuilder.append("api/");
        }
        urlBuilder.append(this.customResourceDefinition.getVersion()).append("/");
        if (this.customResourceDefinition.getScope().equals("Namespaced") && namespace != null) {
            urlBuilder.append("namespaces/").append(namespace).append("/");
        }
        urlBuilder.append(this.customResourceDefinition.getPlural());
        if (name != null) {
            urlBuilder.append("/").append(name);
        }
        return urlBuilder.toString();
    }

    private String getLabelsQueryParam(Map<String, String> labels) {
        StringBuilder labelQueryBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            if (labelQueryBuilder.length() > 0) {
                labelQueryBuilder.append(",");
            }
            labelQueryBuilder.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return labelQueryBuilder.toString();
    }

    private Map<String, Object> makeCall(String url, String body, HttpCallMethod callMethod) {
        return this.makeCall(url, body, callMethod, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> makeCall(String url, String body, HttpCallMethod callMethod, boolean shouldRequestFailure) {
        Request request = body == null ? this.getRequest(url, callMethod) : this.getRequest(url, body, callMethod);
        try (Response response = this.client.newCall(request).execute();){
            if (response.isSuccessful()) {
                String respBody = response.body().string();
                if (Utils.isNullOrEmpty(respBody)) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    return hashMap;
                }
                Map map = (Map)this.objectMapper.readValue(respBody, HashMap.class);
                return map;
            }
            Map<String, Object> map = this.handleFailure(request, response, shouldRequestFailure);
            return map;
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private Map<String, Object> handleFailure(Request request, Response response, boolean shouldRequestFailure) throws IOException {
        if (shouldRequestFailure) {
            throw RawCustomResourceOperationsImpl.requestFailure(request, RawCustomResourceOperationsImpl.createStatus(response));
        }
        return (Map)this.objectMapper.readValue(response.body().string(), HashMap.class);
    }

    private boolean handleDelete(String requestBody) {
        Map<String, Object> response = this.makeCall(this.fetchUrl(null), requestBody, HttpCallMethod.DELETE, false);
        if (response.get("kind").toString().equals("Status")) {
            return response.get("status").toString().equals("Success");
        }
        return true;
    }

    private Map<String, Object> validateAndSubmitRequest(String objectAsString, HttpCallMethod httpCallMethod) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(null), objectAsString, httpCallMethod);
    }

    private Map<String, Object> validateAndSubmitRequest(String resourceUrl, String objectAsString, HttpCallMethod httpCallMethod) throws IOException {
        if (IOHelpers.isJSONValid(objectAsString)) {
            return this.makeCall(resourceUrl, objectAsString, httpCallMethod);
        }
        return this.makeCall(resourceUrl, IOHelpers.convertYamlToJson(objectAsString), httpCallMethod);
    }

    private Request getRequest(String url, HttpCallMethod httpCallMethod) {
        Request.Builder requestBuilder = new Request.Builder();
        switch (httpCallMethod) {
            case GET: {
                requestBuilder.get().url(url);
                break;
            }
            case DELETE: {
                requestBuilder.delete().url(url);
            }
        }
        return requestBuilder.build();
    }

    private Request getRequest(String url, String body, HttpCallMethod httpCallMethod) {
        Request.Builder requestBuilder = new Request.Builder();
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)body);
        switch (httpCallMethod) {
            case DELETE: {
                return requestBuilder.delete(requestBody).url(url).build();
            }
            case POST: {
                return requestBuilder.post(requestBody).url(url).build();
            }
            case PUT: {
                return requestBuilder.put(requestBody).url(url).build();
            }
            case PATCH: {
                return requestBuilder.patch(RequestBody.create((MediaType)JSON_PATCH, (String)body)).url(url).build();
            }
        }
        return requestBuilder.build();
    }

    private String getPatchDiff(String namespace, String customResourceName, Map<String, Object> customResource) throws IOException {
        Map<String, Object> oldObject = this.get(namespace, customResourceName);
        oldObject.put("status", null);
        customResource.put("status", null);
        JsonNode newone = JsonDiff.asJson((JsonNode)PatchUtils.patchMapper().valueToTree(oldObject), (JsonNode)PatchUtils.patchMapper().valueToTree(customResource));
        return this.objectMapper.writeValueAsString((Object)newone);
    }

    private DeleteOptions fetchDeleteOptions(boolean cascading, String propagationPolicy) {
        DeleteOptionsBuilder deleteOptionsBuilder = new DeleteOptionsBuilder();
        String resolvedPropagationPolicy = this.resolvePropagationPolicy(propagationPolicy);
        if (resolvedPropagationPolicy != null) {
            deleteOptionsBuilder.withPropagationPolicy(resolvedPropagationPolicy);
        } else {
            deleteOptionsBuilder.withOrphanDependents(!cascading);
        }
        if (this.gracePeriodInSeconds > 0L) {
            deleteOptionsBuilder.withGracePeriodSeconds(this.gracePeriodInSeconds);
        }
        if (this.dryRun) {
            deleteOptionsBuilder.withDryRun(Collections.singletonList("All"));
        }
        return deleteOptionsBuilder.build();
    }

    private String resolvePropagationPolicy(String propagationPolicyProvided) {
        if (propagationPolicyProvided != null) {
            return propagationPolicyProvided;
        }
        if (this.deletionPropagation != null) {
            return this.deletionPropagation;
        }
        return null;
    }

    private boolean pickNamespaceOrNameBasedOnScopeAndDelete(String namespaceOrName, String deleteOptionsAsString) {
        String operationNamespace = null;
        String operationName = null;
        if (this.customResourceDefinition.getScope().equals("Namespaced")) {
            operationNamespace = namespaceOrName;
        } else {
            operationName = namespaceOrName;
        }
        return new RawCustomResourceOperationsImpl(this.client, this.config, this.customResourceDefinition, operationNamespace, operationName, this.gracePeriodInSeconds, this.cascading, this.deletionPropagation, this.listOptions, this.dryRun).handleDelete(deleteOptionsAsString);
    }

    private static enum HttpCallMethod {
        GET,
        POST,
        PUT,
        PATCH,
        DELETE;

    }
}

