/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluentImpl;
import java.util.Objects;

public class TLSConfigBuilder
extends TLSConfigFluentImpl<TLSConfigBuilder>
implements VisitableBuilder<TLSConfig, TLSConfigBuilder> {
    TLSConfigFluent<?> fluent;
    Boolean validationEnabled;

    public TLSConfigBuilder() {
        this(true);
    }

    public TLSConfigBuilder(Boolean validationEnabled) {
        this(new TLSConfig(), validationEnabled);
    }

    public TLSConfigBuilder(TLSConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TLSConfigBuilder(TLSConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TLSConfig(), validationEnabled);
    }

    public TLSConfigBuilder(TLSConfigFluent<?> fluent, TLSConfig instance) {
        this(fluent, instance, true);
    }

    public TLSConfigBuilder(TLSConfigFluent<?> fluent, TLSConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCa(instance.getCa());
        fluent.withCaFile(instance.getCaFile());
        fluent.withCert(instance.getCert());
        fluent.withCertFile(instance.getCertFile());
        fluent.withInsecureSkipVerify(instance.getInsecureSkipVerify());
        fluent.withKeyFile(instance.getKeyFile());
        fluent.withKeySecret(instance.getKeySecret());
        fluent.withServerName(instance.getServerName());
        this.validationEnabled = validationEnabled;
    }

    public TLSConfigBuilder(TLSConfig instance) {
        this(instance, (Boolean)true);
    }

    public TLSConfigBuilder(TLSConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCa(instance.getCa());
        this.withCaFile(instance.getCaFile());
        this.withCert(instance.getCert());
        this.withCertFile(instance.getCertFile());
        this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
        this.withKeyFile(instance.getKeyFile());
        this.withKeySecret(instance.getKeySecret());
        this.withServerName(instance.getServerName());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public TLSConfig build() {
        TLSConfig buildable = new TLSConfig(this.fluent.getCa(), this.fluent.getCaFile(), this.fluent.getCert(), this.fluent.getCertFile(), this.fluent.isInsecureSkipVerify(), this.fluent.getKeyFile(), this.fluent.getKeySecret(), this.fluent.getServerName());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TLSConfigBuilder that = (TLSConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

