/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodOperationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PodOperationUtil.class);

    private PodOperationUtil() {
    }

    public static List<PodResource<Pod>> getFilteredPodsForLogs(PodOperationsImpl podOperations, PodList controllerPodList, String controllerUid) {
        ArrayList<PodResource<Pod>> pods = new ArrayList<PodResource<Pod>>();
        for (Pod pod : controllerPodList.getItems()) {
            OwnerReference ownerReference = KubernetesResourceUtil.getControllerUid(pod);
            if (ownerReference == null || !ownerReference.getUid().equals(controllerUid)) continue;
            pods.add((PodResource)podOperations.withName(pod.getMetadata().getName()));
        }
        return pods;
    }

    public static PodOperationsImpl getGenericPodOperations(OperationContext context, boolean isPretty, Integer podLogWaitTimeout) {
        return new PodOperationsImpl(new PodOperationContext(context.getClient(), context.getConfig(), context.getPlural(), context.getNamespace(), null, null, "v1", context.getCascading(), context.getItem(), context.getLabels(), context.getLabelsNot(), context.getLabelsIn(), context.getLabelsNotIn(), context.getFields(), context.getFieldsNot(), context.getResourceVersion(), context.isReloadingFromServer(), context.getGracePeriodSeconds(), context.getPropagationPolicy(), context.getWatchRetryInitialBackoffMillis(), context.getWatchRetryBackoffMultiplier(), context.isNamespaceFromGlobalConfig(), context.getDryRun(), null, null, null, null, null, null, null, null, null, false, false, false, null, null, null, isPretty, null, null, null, null, null, podLogWaitTimeout));
    }

    public static List<PodResource<Pod>> getPodOperationsForController(OperationContext context, String controllerUid, Map<String, String> selectorLabels, boolean isPretty, Integer podLogWaitTimeout) {
        return PodOperationUtil.getPodOperationsForController(PodOperationUtil.getGenericPodOperations(context, isPretty, podLogWaitTimeout), controllerUid, selectorLabels);
    }

    static List<PodResource<Pod>> getPodOperationsForController(PodOperationsImpl podOperations, String controllerUid, Map<String, String> selectorLabels) {
        PodList controllerPodList = (PodList)podOperations.withLabels((Map)selectorLabels).list();
        return PodOperationUtil.getFilteredPodsForLogs(podOperations, controllerPodList, controllerUid);
    }

    public static void waitUntilReadyBeforeFetchingLogs(PodResource<Pod> podOperation, Integer logWaitTimeout) {
        try {
            Pod pod = (Pod)((Gettable)podOperation.fromServer()).get();
            if (pod != null && pod.getStatus() != null && pod.getStatus().getPhase().equals("Pending")) {
                podOperation.waitUntilReady(logWaitTimeout.intValue(), TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            LOG.debug("Interrupted while waiting for Pod to become Ready: {}", (Object)interruptedException.getMessage());
        }
        catch (Exception otherException) {
            LOG.debug("Error while waiting for Pod to become Ready: {}", (Object)otherException.getMessage());
        }
    }
}

