/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingBuilder;
import io.fabric8.openshift.api.model.RoleBindingFluent;
import io.fabric8.openshift.api.model.RoleBindingList;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import okhttp3.OkHttpClient;

public class RoleBindingOperationsImpl
extends OpenShiftOperation<RoleBinding, RoleBindingList, Resource<RoleBinding>> {
    public static final String SERVICE_ACCOUNT = "ServiceAccount";
    public static final String USER = "User";
    public static final String GROUP = "Group";

    public RoleBindingOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public RoleBindingOperationsImpl(OperationContext context) {
        super(context.withApiGroupName("authorization.openshift.io").withPlural("rolebindings"));
        this.type = RoleBinding.class;
        this.listType = RoleBindingList.class;
    }

    public RoleBindingOperationsImpl newInstance(OperationContext context) {
        return new RoleBindingOperationsImpl(context);
    }

    @Override
    public RoleBinding replace(RoleBinding item) {
        RoleBinding enriched = this.enrichRoleBinding(item);
        return super.replace(enriched);
    }

    @Override
    public RoleBinding patch(RoleBinding item) {
        RoleBinding enriched = this.enrichRoleBinding(item);
        return super.patch(enriched);
    }

    @Override
    protected RoleBinding handleCreate(RoleBinding resource) throws ExecutionException, InterruptedException, IOException {
        return super.handleCreate(this.enrichRoleBinding(resource));
    }

    private RoleBinding enrichRoleBinding(RoleBinding binding) {
        RoleBindingBuilder builder = new RoleBindingBuilder(binding);
        if (binding.getUserNames() != null && !binding.getUserNames().isEmpty() || binding.getGroupNames() != null && !binding.getGroupNames().isEmpty()) {
            this.enrichFromUsersAndGroups(builder, binding.getUserNames(), binding.getGroupNames());
        } else {
            this.enrichFromSubjects(builder, binding.getSubjects());
            this.enrichSubjectsNamespace(builder);
        }
        return builder.build();
    }

    private void enrichSubjectsNamespace(RoleBindingBuilder builder) {
        builder.accept(new Visitor[]{new TypedVisitor<ObjectReferenceBuilder>(){

            @Override
            public void visit(ObjectReferenceBuilder o) {
                if (o.getKind() != null && o.getKind().equals(RoleBindingOperationsImpl.SERVICE_ACCOUNT) && (o.getNamespace() == null || o.getNamespace().isEmpty())) {
                    o.withNamespace(RoleBindingOperationsImpl.this.getNamespace());
                }
            }
        }});
    }

    @Override
    public RoleBinding edit(Visitor ... visitors) {
        return this.patch(((RoleBindingBuilder)new RoleBindingBuilder((RoleBinding)this.getMandatory()).accept(visitors)).build());
    }

    private void enrichFromUsersAndGroups(RoleBindingBuilder builder, List<String> userNames, List<String> groupNames) {
        builder.withSubjects(new ObjectReference[0]);
        if (userNames != null) {
            for (String userName : userNames) {
                String[] splitUserName;
                if (userName.startsWith("system:serviceaccount:") && (splitUserName = userName.split(":")).length == 4) {
                    ((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind(SERVICE_ACCOUNT)).withNamespace(splitUserName[2])).withName(splitUserName[3])).endSubject();
                    continue;
                }
                ((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind(USER)).withName(userName)).endSubject();
            }
        }
        if (groupNames != null) {
            for (String groupName : groupNames) {
                ((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind(GROUP)).withName(groupName)).endSubject();
            }
        }
    }

    private void enrichFromSubjects(RoleBindingBuilder builder, List<ObjectReference> subjects) {
        for (ObjectReference ref : subjects) {
            switch (ref.getKind()) {
                case "User": {
                    builder.addToUserNames(ref.getName());
                    break;
                }
                case "ServiceAccount": {
                    String namespace = ref.getNamespace();
                    if (namespace == null || namespace.isEmpty()) {
                        namespace = this.getNamespace();
                    }
                    builder.addToUserNames("system:serviceaccount:" + namespace + ":" + ref.getName());
                    break;
                }
                case "Group": {
                    builder.addToGroupNames(ref.getName());
                }
            }
        }
    }
}

