/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.v1.BackupReference;
import io.fabric8.openshift.api.model.hive.v1.BackupReferenceBuilder;
import io.fabric8.openshift.api.model.hive.v1.BackupReferenceFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.CheckpointSpec;
import io.fabric8.openshift.api.model.hive.v1.CheckpointSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class CheckpointSpecFluentImpl<A extends CheckpointSpecFluent<A>>
extends BaseFluent<A>
implements CheckpointSpecFluent<A> {
    private String lastBackupChecksum;
    private BackupReferenceBuilder lastBackupRef;
    private String lastBackupTime;
    private Map<String, Object> additionalProperties;

    public CheckpointSpecFluentImpl() {
    }

    public CheckpointSpecFluentImpl(CheckpointSpec instance) {
        this.withLastBackupChecksum(instance.getLastBackupChecksum());
        this.withLastBackupRef(instance.getLastBackupRef());
        this.withLastBackupTime(instance.getLastBackupTime());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getLastBackupChecksum() {
        return this.lastBackupChecksum;
    }

    @Override
    public A withLastBackupChecksum(String lastBackupChecksum) {
        this.lastBackupChecksum = lastBackupChecksum;
        return (A)this;
    }

    @Override
    public Boolean hasLastBackupChecksum() {
        return this.lastBackupChecksum != null;
    }

    @Override
    @Deprecated
    public A withNewLastBackupChecksum(String arg0) {
        return this.withLastBackupChecksum(new String(arg0));
    }

    @Override
    @Deprecated
    public BackupReference getLastBackupRef() {
        return this.lastBackupRef != null ? this.lastBackupRef.build() : null;
    }

    @Override
    public BackupReference buildLastBackupRef() {
        return this.lastBackupRef != null ? this.lastBackupRef.build() : null;
    }

    @Override
    public A withLastBackupRef(BackupReference lastBackupRef) {
        this._visitables.get("lastBackupRef").remove(this.lastBackupRef);
        if (lastBackupRef != null) {
            this.lastBackupRef = new BackupReferenceBuilder(lastBackupRef);
            this._visitables.get("lastBackupRef").add(this.lastBackupRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLastBackupRef() {
        return this.lastBackupRef != null;
    }

    @Override
    public A withNewLastBackupRef(String name, String namespace) {
        return this.withLastBackupRef(new BackupReference(name, namespace));
    }

    @Override
    public CheckpointSpecFluent.LastBackupRefNested<A> withNewLastBackupRef() {
        return new LastBackupRefNestedImpl();
    }

    @Override
    public CheckpointSpecFluent.LastBackupRefNested<A> withNewLastBackupRefLike(BackupReference item) {
        return new LastBackupRefNestedImpl(item);
    }

    @Override
    public CheckpointSpecFluent.LastBackupRefNested<A> editLastBackupRef() {
        return this.withNewLastBackupRefLike(this.getLastBackupRef());
    }

    @Override
    public CheckpointSpecFluent.LastBackupRefNested<A> editOrNewLastBackupRef() {
        return this.withNewLastBackupRefLike(this.getLastBackupRef() != null ? this.getLastBackupRef() : new BackupReferenceBuilder().build());
    }

    @Override
    public CheckpointSpecFluent.LastBackupRefNested<A> editOrNewLastBackupRefLike(BackupReference item) {
        return this.withNewLastBackupRefLike(this.getLastBackupRef() != null ? this.getLastBackupRef() : item);
    }

    @Override
    public String getLastBackupTime() {
        return this.lastBackupTime;
    }

    @Override
    public A withLastBackupTime(String lastBackupTime) {
        this.lastBackupTime = lastBackupTime;
        return (A)this;
    }

    @Override
    public Boolean hasLastBackupTime() {
        return this.lastBackupTime != null;
    }

    @Override
    @Deprecated
    public A withNewLastBackupTime(String arg0) {
        return this.withLastBackupTime(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointSpecFluentImpl that = (CheckpointSpecFluentImpl)o;
        if (this.lastBackupChecksum != null ? !this.lastBackupChecksum.equals(that.lastBackupChecksum) : that.lastBackupChecksum != null) {
            return false;
        }
        if (this.lastBackupRef != null ? !this.lastBackupRef.equals(that.lastBackupRef) : that.lastBackupRef != null) {
            return false;
        }
        if (this.lastBackupTime != null ? !this.lastBackupTime.equals(that.lastBackupTime) : that.lastBackupTime != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.lastBackupChecksum, this.lastBackupRef, this.lastBackupTime, this.additionalProperties, super.hashCode());
    }

    public class LastBackupRefNestedImpl<N>
    extends BackupReferenceFluentImpl<CheckpointSpecFluent.LastBackupRefNested<N>>
    implements CheckpointSpecFluent.LastBackupRefNested<N>,
    Nested<N> {
        BackupReferenceBuilder builder;

        LastBackupRefNestedImpl(BackupReference item) {
            this.builder = new BackupReferenceBuilder(this, item);
        }

        LastBackupRefNestedImpl() {
            this.builder = new BackupReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CheckpointSpecFluentImpl.this.withLastBackupRef(this.builder.build());
        }

        @Override
        public N endLastBackupRef() {
            return this.and();
        }
    }
}

