/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.hive.v1.ClusterState;
import io.fabric8.openshift.api.model.hive.v1.ClusterStateFluent;
import io.fabric8.openshift.api.model.hive.v1.ClusterStateFluentImpl;
import java.util.Objects;

public class ClusterStateBuilder
extends ClusterStateFluentImpl<ClusterStateBuilder>
implements VisitableBuilder<ClusterState, ClusterStateBuilder> {
    ClusterStateFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterStateBuilder() {
        this(false);
    }

    public ClusterStateBuilder(Boolean validationEnabled) {
        this(new ClusterState(), validationEnabled);
    }

    public ClusterStateBuilder(ClusterStateFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ClusterStateBuilder(ClusterStateFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterState(), validationEnabled);
    }

    public ClusterStateBuilder(ClusterStateFluent<?> fluent, ClusterState instance) {
        this(fluent, instance, false);
    }

    public ClusterStateBuilder(ClusterStateFluent<?> fluent, ClusterState instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ClusterStateBuilder(ClusterState instance) {
        this(instance, (Boolean)false);
    }

    public ClusterStateBuilder(ClusterState instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ClusterState build() {
        ClusterState buildable = new ClusterState(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterStateBuilder that = (ClusterStateBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

