/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollableScalableResourceOperation;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1.ReplicaSetRollingUpdater;
import io.fabric8.kubernetes.client.utils.PodOperationUtil;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class ReplicaSetOperationsImpl
extends RollableScalableResourceOperation<ReplicaSet, ReplicaSetList, RollableScalableResource<ReplicaSet>>
implements TimeoutImageEditReplacePatchable<ReplicaSet> {
    public ReplicaSetOperationsImpl(OkHttpClient client, Config config) {
        this(client, config, null);
    }

    public ReplicaSetOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(new RollingOperationContext(), new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
    }

    public ReplicaSetOperationsImpl(RollingOperationContext context, OperationContext superContext) {
        super(context, superContext.withApiGroupName("extensions").withApiGroupVersion("v1beta1").withPlural("replicasets"), ReplicaSet.class, ReplicaSetList.class);
    }

    public ReplicaSetOperationsImpl newInstance(OperationContext context) {
        return new ReplicaSetOperationsImpl(this.rollingOperationContext, context);
    }

    public ReplicaSetOperationsImpl newInstance(RollingOperationContext context) {
        return new ReplicaSetOperationsImpl(context, this.context);
    }

    @Override
    public ReplicaSet updateImage(String image) {
        ReplicaSet oldRC = (ReplicaSet)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing replication controller doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container container = oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next();
        return this.updateImage((Map)Collections.singletonMap(container.getName(), image));
    }

    @Override
    public ReplicaSet updateImage(Map<String, String> containerToImageMap) {
        ReplicaSet replicationController = (ReplicaSet)this.get();
        if (replicationController == null) {
            throw new KubernetesClientException("Existing replica set doesn't exist");
        }
        if (replicationController.getSpec().getTemplate().getSpec().getContainers().isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        List<Container> containers = replicationController.getSpec().getTemplate().getSpec().getContainers();
        for (Container container : containers) {
            if (!containerToImageMap.containsKey(container.getName())) continue;
            container.setImage(containerToImageMap.get(container.getName()));
        }
        replicationController.getSpec().getTemplate().getSpec().setContainers(containers);
        return this.sendPatchedObject(this.get(), replicationController);
    }

    @Override
    public ReplicaSet pause() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" pausing is not supported");
    }

    @Override
    public ReplicaSet resume() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" resuming is not supported");
    }

    @Override
    public ReplicaSet restart() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" restarting is not supported");
    }

    @Override
    public ReplicaSet undo() {
        throw new UnsupportedOperationException("no rollbacker has been implemented for \"" + ((ReplicaSet)this.get()).getKind() + "\"");
    }

    @Override
    public ReplicaSet withReplicas(int count) {
        return this.cascading(false).accept((T r) -> r.getSpec().setReplicas(count));
    }

    @Override
    public RollingUpdater<ReplicaSet, ReplicaSetList> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new ReplicaSetRollingUpdater(this.client, this.config, this.getNamespace(), rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    public int getCurrentReplicas(ReplicaSet current) {
        return current.getStatus().getReplicas();
    }

    @Override
    public int getDesiredReplicas(ReplicaSet item) {
        return item.getSpec().getReplicas();
    }

    @Override
    public long getObservedGeneration(ReplicaSet current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    @Override
    public Status rollback(DeploymentRollback deploymentRollback) {
        throw new KubernetesClientException("rollback not supported in case of ReplicaSets");
    }

    @Override
    public String getLog(Boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<PodResource<Pod>> podOperationList = this.doGetLog(isPretty);
        for (PodResource<Pod> podOperation : podOperationList) {
            stringBuilder.append(podOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<PodResource<Pod>> doGetLog(boolean isPretty) {
        ReplicaSet replicaSet = (ReplicaSet)this.requireFromServer();
        return PodOperationUtil.getPodOperationsForController(this.context, replicaSet.getMetadata().getUid(), ReplicaSetOperationsImpl.getReplicaSetSelectorLabels(replicaSet), isPretty, this.rollingOperationContext.getLogWaitTimeout(), this.rollingOperationContext.getContainerId());
    }

    @Override
    public Reader getLogReader() {
        return PodOperationUtil.getLogReader(this.doGetLog(false));
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        return PodOperationUtil.watchLog(this.doGetLog(false), out);
    }

    static Map<String, String> getReplicaSetSelectorLabels(ReplicaSet replicaSet) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (replicaSet != null && replicaSet.getSpec() != null && replicaSet.getSpec().getSelector() != null) {
            labels.putAll(replicaSet.getSpec().getSelector().getMatchLabels());
        }
        return labels;
    }
}

