/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.ServiceBackendPort;
import io.fabric8.kubernetes.api.model.networking.v1.ServiceBackendPortBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.ServiceBackendPortFluentImpl;
import java.util.Objects;

public class IngressServiceBackendFluentImpl<A extends IngressServiceBackendFluent<A>>
extends BaseFluent<A>
implements IngressServiceBackendFluent<A> {
    private String name;
    private ServiceBackendPortBuilder port;

    public IngressServiceBackendFluentImpl() {
    }

    public IngressServiceBackendFluentImpl(IngressServiceBackend instance) {
        this.withName(instance.getName());
        this.withPort(instance.getPort());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    @Deprecated
    public ServiceBackendPort getPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public ServiceBackendPort buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public A withPort(ServiceBackendPort port) {
        this._visitables.get("port").remove(this.port);
        if (port != null) {
            this.port = new ServiceBackendPortBuilder(port);
            this._visitables.get("port").add(this.port);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public A withNewPort(String name, Integer number) {
        return this.withPort(new ServiceBackendPort(name, number));
    }

    @Override
    public IngressServiceBackendFluent.PortNested<A> withNewPort() {
        return new PortNestedImpl();
    }

    @Override
    public IngressServiceBackendFluent.PortNested<A> withNewPortLike(ServiceBackendPort item) {
        return new PortNestedImpl(item);
    }

    @Override
    public IngressServiceBackendFluent.PortNested<A> editPort() {
        return this.withNewPortLike(this.getPort());
    }

    @Override
    public IngressServiceBackendFluent.PortNested<A> editOrNewPort() {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : new ServiceBackendPortBuilder().build());
    }

    @Override
    public IngressServiceBackendFluent.PortNested<A> editOrNewPortLike(ServiceBackendPort item) {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressServiceBackendFluentImpl that = (IngressServiceBackendFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.port != null ? !this.port.equals(that.port) : that.port != null);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.port, super.hashCode());
    }

    public class PortNestedImpl<N>
    extends ServiceBackendPortFluentImpl<IngressServiceBackendFluent.PortNested<N>>
    implements IngressServiceBackendFluent.PortNested<N>,
    Nested<N> {
        private final ServiceBackendPortBuilder builder;

        PortNestedImpl(ServiceBackendPort item) {
            this.builder = new ServiceBackendPortBuilder(this, item);
        }

        PortNestedImpl() {
            this.builder = new ServiceBackendPortBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressServiceBackendFluentImpl.this.withPort(this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

