/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.server.mock;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.WatchEvent;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.crud.AttributeSet;
import io.fabric8.mockwebserver.internal.WebSocketMessage;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;

class WatchEventsListener
extends WebSocketListener {
    private final AtomicReference<WebSocket> webSocketRef = new AtomicReference();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final AttributeSet attributeSet;
    private final Context context;
    private final Set<WatchEventsListener> watchEventListenerList;
    private final Logger logger;

    public WatchEventsListener(Context context, AttributeSet attributeSet, Set<WatchEventsListener> watchEventListenerList, Logger logger) {
        this.logger = logger;
        this.context = context;
        this.attributeSet = attributeSet;
        this.watchEventListenerList = watchEventListenerList;
    }

    public boolean attributeMatches(AttributeSet set) {
        return set.matches(this.attributeSet);
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.webSocketRef.set(webSocket);
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        this.webSocketRef.get().close(code, reason);
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        if (this.webSocketRef.get() != null) {
            this.webSocketRef.get().close(code, reason);
        }
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            this.logger.debug(e.getLocalizedMessage());
            Thread.currentThread().interrupt();
        }
        this.watchEventListenerList.remove((Object)this);
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        webSocket.close(1000, t.getMessage());
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            this.logger.debug(e.getLocalizedMessage());
            Thread.currentThread().interrupt();
        }
        this.watchEventListenerList.remove((Object)this);
    }

    public void sendWebSocketResponse(String object, String eventType) {
        WebSocketMessage message = WatchEventsListener.toWebSocketMessage(this.context, new WatchEvent(Serialization.unmarshal(object, KubernetesResource.class), eventType));
        this.executor.schedule(() -> this.webSocketRef.get().send(message.getBody()), (long)message.getDelay(), TimeUnit.SECONDS);
    }

    private static WebSocketMessage toWebSocketMessage(Context context, Object content) {
        return WatchEventsListener.toWebSocketMessage(context, content, true);
    }

    private static WebSocketMessage toWebSocketMessage(Context context, Object content, Boolean toBeRemoved) {
        return WatchEventsListener.toWebSocketMessage(context, 0L, content, toBeRemoved);
    }

    private static WebSocketMessage toWebSocketMessage(Context context, Long delay, Object content, Boolean toBeRemoved) {
        if (content instanceof String) {
            return new WebSocketMessage(delay, (String)content, toBeRemoved.booleanValue());
        }
        if (content instanceof WebSocketMessage) {
            return (WebSocketMessage)content;
        }
        try {
            return WatchEventsListener.toWebSocketMessage(context, delay, context.getMapper().writeValueAsString(content), toBeRemoved);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

