/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_6.handlers;

import io.fabric8.kubernetes.clnt.v4_6.Config;
import io.fabric8.kubernetes.clnt.v4_6.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_6.Watch;
import io.fabric8.kubernetes.clnt.v4_6.Watcher;
import io.fabric8.kubernetes.clnt.v4_6.dsl.Gettable;
import io.fabric8.openshift.api.model.v4_6.BuildConfig;
import io.fabric8.openshift.api.model.v4_6.BuildConfigBuilder;
import io.fabric8.openshift.clnt.v4_6.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_6.dsl.BuildConfigResource;
import io.fabric8.openshift.clnt.v4_6.dsl.internal.BuildConfigOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class BuildConfigHandler
implements ResourceHandler<BuildConfig, BuildConfigBuilder> {
    @Override
    public String getKind() {
        return BuildConfig.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "build.openshift.io/v1";
    }

    @Override
    public BuildConfig create(OkHttpClient client, Config config, String namespace, BuildConfig item) {
        return (BuildConfig)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new BuildConfig[0]);
    }

    @Override
    public BuildConfig replace(OkHttpClient client, Config config, String namespace, BuildConfig item) {
        return (BuildConfig)((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public BuildConfig reload(OkHttpClient client, Config config, String namespace, BuildConfig item) {
        return (BuildConfig)((Gettable)((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public BuildConfigBuilder edit(BuildConfig item) {
        return new BuildConfigBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, BuildConfig item) {
        if (cascading.booleanValue()) {
            return (Boolean)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).cascading(true).delete();
        }
        return (Boolean)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, BuildConfig item, Watcher<BuildConfig> watcher) {
        return (Watch)((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, BuildConfig item, String resourceVersion, Watcher<BuildConfig> watcher) {
        return (Watch)((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public BuildConfig waitUntilReady(OkHttpClient client, Config config, String namespace, BuildConfig item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (BuildConfig)((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public BuildConfig waitUntilCondition(OkHttpClient client, Config config, String namespace, BuildConfig item, Predicate<BuildConfig> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (BuildConfig)((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

