/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_6.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_6.batch.DoneableJob;
import io.fabric8.kubernetes.api.model.v4_6.batch.Job;
import io.fabric8.kubernetes.api.model.v4_6.batch.JobFluent;
import io.fabric8.kubernetes.api.model.v4_6.batch.JobList;
import io.fabric8.kubernetes.clnt.v4_6.Config;
import io.fabric8.kubernetes.clnt.v4_6.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_6.dsl.Reaper;
import io.fabric8.kubernetes.clnt.v4_6.dsl.ScalableResource;
import io.fabric8.kubernetes.clnt.v4_6.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v4_6.dsl.base.OperationContext;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobOperationsImpl
extends HasMetadataOperation<Job, JobList, DoneableJob, ScalableResource<Job, DoneableJob>>
implements ScalableResource<Job, DoneableJob> {
    static final transient Logger LOG = LoggerFactory.getLogger(JobOperationsImpl.class);

    public JobOperationsImpl(OkHttpClient client, Config config) {
        this(client, config, null);
    }

    public JobOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withCascading(true));
    }

    public JobOperationsImpl(OperationContext context) {
        super(context.withApiGroupName("batch").withApiGroupVersion("v1").withPlural("jobs"));
        this.type = Job.class;
        this.listType = JobList.class;
        this.doneableType = DoneableJob.class;
    }

    public JobOperationsImpl newInstance(OperationContext context) {
        return new JobOperationsImpl(context);
    }

    @Override
    public ScalableResource<Job, DoneableJob> load(InputStream is) {
        try {
            Job item = JobOperationsImpl.unmarshal(is, Job.class);
            return new JobOperationsImpl(this.context.withItem(item));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public ScalableResource<Job, DoneableJob> fromServer() {
        return new JobOperationsImpl(this.context.withReloadingFromServer(true));
    }

    @Override
    public Job scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public Job scale(int count, boolean wait) {
        Job res = ((DoneableJob)((JobFluent.SpecNested)((DoneableJob)this.cascading(false).edit()).editSpec().withParallelism(count)).endSpec()).done();
        if (wait) {
            this.waitUntilJobIsScaled();
            res = (Job)this.getMandatory();
        }
        return res;
    }

    private void waitUntilJobIsScaled() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference atomicJob = new AtomicReference();
        Runnable jobPoller = () -> {
            try {
                Job job = (Job)this.getMandatory();
                atomicJob.set(job);
                Integer activeJobs = job.getStatus().getActive();
                if (activeJobs == null) {
                    activeJobs = 0;
                }
                if (Objects.equals(job.getSpec().getParallelism(), activeJobs)) {
                    countDownLatch.countDown();
                } else {
                    LOG.debug("Only {}/{} pods scheduled for Job: {} in namespace: {} seconds so waiting...", new Object[]{job.getStatus().getActive(), job.getSpec().getParallelism(), job.getMetadata().getName(), this.namespace});
                }
            }
            catch (Throwable t) {
                LOG.error("Error while waiting for Job to be scaled.", t);
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(jobPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            countDownLatch.await(this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS);
            executor.shutdown();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            poller.cancel(true);
            executor.shutdown();
            LOG.error("Only {}/{} pod(s) ready for Job: {} in namespace: {} - giving up", new Object[]{((Job)atomicJob.get()).getStatus().getActive(), ((Job)atomicJob.get()).getSpec().getParallelism(), ((Job)atomicJob.get()).getMetadata().getName(), this.namespace});
        }
    }

    private static class JobReaper
    implements Reaper {
        private JobOperationsImpl oper;

        public JobReaper(JobOperationsImpl oper) {
            this.oper = oper;
        }

        @Override
        public boolean reap() {
            this.oper.scale(0, true);
            return false;
        }
    }
}

