/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_6.apps;

import io.fabric8.kubernetes.api.builder.v4_6.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_6.apps.StatefulSetCondition;
import io.fabric8.kubernetes.api.model.v4_6.apps.StatefulSetConditionFluent;
import io.fabric8.kubernetes.api.model.v4_6.apps.StatefulSetConditionFluentImpl;

public class StatefulSetConditionBuilder
extends StatefulSetConditionFluentImpl<StatefulSetConditionBuilder>
implements VisitableBuilder<StatefulSetCondition, StatefulSetConditionBuilder> {
    StatefulSetConditionFluent<?> fluent;
    Boolean validationEnabled;

    public StatefulSetConditionBuilder() {
        this(true);
    }

    public StatefulSetConditionBuilder(Boolean validationEnabled) {
        this(new StatefulSetCondition(), validationEnabled);
    }

    public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StatefulSetCondition(), validationEnabled);
    }

    public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent, StatefulSetCondition instance) {
        this(fluent, instance, true);
    }

    public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent, StatefulSetCondition instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLastTransitionTime(instance.getLastTransitionTime());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        fluent.withStatus(instance.getStatus());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetConditionBuilder(StatefulSetCondition instance) {
        this(instance, (Boolean)true);
    }

    public StatefulSetConditionBuilder(StatefulSetCondition instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLastTransitionTime(instance.getLastTransitionTime());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public StatefulSetCondition build() {
        StatefulSetCondition buildable = new StatefulSetCondition(this.fluent.getLastTransitionTime(), this.fluent.getMessage(), this.fluent.getReason(), this.fluent.getStatus(), this.fluent.getType());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatefulSetConditionBuilder that = (StatefulSetConditionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

