/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apiextensions;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionVersionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionVersionFluentImpl;
import javax.validation.Validator;

public class CustomResourceDefinitionVersionBuilder
extends CustomResourceDefinitionVersionFluentImpl<CustomResourceDefinitionVersionBuilder>
implements VisitableBuilder<CustomResourceDefinitionVersion, CustomResourceDefinitionVersionBuilder> {
    CustomResourceDefinitionVersionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CustomResourceDefinitionVersionBuilder() {
        this(true);
    }

    public CustomResourceDefinitionVersionBuilder(Boolean validationEnabled) {
        this(new CustomResourceDefinitionVersion(), validationEnabled);
    }

    public CustomResourceDefinitionVersionBuilder(CustomResourceDefinitionVersionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CustomResourceDefinitionVersionBuilder(CustomResourceDefinitionVersionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CustomResourceDefinitionVersion(), validationEnabled);
    }

    public CustomResourceDefinitionVersionBuilder(CustomResourceDefinitionVersionFluent<?> fluent, CustomResourceDefinitionVersion instance) {
        this(fluent, instance, true);
    }

    public CustomResourceDefinitionVersionBuilder(CustomResourceDefinitionVersionFluent<?> fluent, CustomResourceDefinitionVersion instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAdditionalPrinterColumns(instance.getAdditionalPrinterColumns());
        fluent.withName(instance.getName());
        fluent.withSchema(instance.getSchema());
        fluent.withServed(instance.getServed());
        fluent.withStorage(instance.getStorage());
        fluent.withSubresources(instance.getSubresources());
        this.validationEnabled = validationEnabled;
    }

    public CustomResourceDefinitionVersionBuilder(CustomResourceDefinitionVersion instance) {
        this(instance, (Boolean)true);
    }

    public CustomResourceDefinitionVersionBuilder(CustomResourceDefinitionVersion instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAdditionalPrinterColumns(instance.getAdditionalPrinterColumns());
        this.withName(instance.getName());
        this.withSchema(instance.getSchema());
        this.withServed(instance.getServed());
        this.withStorage(instance.getStorage());
        this.withSubresources(instance.getSubresources());
        this.validationEnabled = validationEnabled;
    }

    public CustomResourceDefinitionVersionBuilder(Validator validator) {
        this(new CustomResourceDefinitionVersion(), (Boolean)true);
    }

    public CustomResourceDefinitionVersionBuilder(CustomResourceDefinitionVersionFluent<?> fluent, CustomResourceDefinitionVersion instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAdditionalPrinterColumns(instance.getAdditionalPrinterColumns());
        fluent.withName(instance.getName());
        fluent.withSchema(instance.getSchema());
        fluent.withServed(instance.getServed());
        fluent.withStorage(instance.getStorage());
        fluent.withSubresources(instance.getSubresources());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public CustomResourceDefinitionVersionBuilder(CustomResourceDefinitionVersion instance, Validator validator) {
        this.fluent = this;
        this.withAdditionalPrinterColumns(instance.getAdditionalPrinterColumns());
        this.withName(instance.getName());
        this.withSchema(instance.getSchema());
        this.withServed(instance.getServed());
        this.withStorage(instance.getStorage());
        this.withSubresources(instance.getSubresources());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public CustomResourceDefinitionVersion build() {
        CustomResourceDefinitionVersion buildable = new CustomResourceDefinitionVersion(this.fluent.getAdditionalPrinterColumns(), this.fluent.getName(), this.fluent.getSchema(), this.fluent.isServed(), this.fluent.isStorage(), this.fluent.getSubresources());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomResourceDefinitionVersionBuilder that = (CustomResourceDefinitionVersionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

