/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.ProjectOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ProjectHandler
implements ResourceHandler<Project, ProjectBuilder> {
    @Override
    public String getKind() {
        return Project.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "${apiGroup}/${apiVersion}";
    }

    @Override
    public Project create(OkHttpClient client, Config config, String namespace, Project item) {
        return (Project)new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Project[0]);
    }

    @Override
    public Project replace(OkHttpClient client, Config config, String namespace, Project item) {
        return (Project)((Resource)new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Project reload(OkHttpClient client, Config config, String namespace, Project item) {
        return (Project)((Gettable)((Resource)new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ProjectBuilder edit(Project item) {
        return new ProjectBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Project item) {
        return (Boolean)new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Project item, Watcher<Project> watcher) {
        return (Watch)((Resource)new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Project item, String resourceVersion, Watcher<Project> watcher) {
        return (Watch)((Resource)new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Project waitUntilReady(OkHttpClient client, Config config, String namespace, Project item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Project)((Resource)new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Project waitUntilCondition(OkHttpClient client, Config config, String namespace, Project item, Predicate<Project> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Project)((Resource)new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

