/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.GroupList;
import io.fabric8.openshift.api.model.GroupListFluent;
import io.fabric8.openshift.api.model.GroupListFluentImpl;
import javax.validation.Validator;

public class GroupListBuilder
extends GroupListFluentImpl<GroupListBuilder>
implements VisitableBuilder<GroupList, GroupListBuilder> {
    GroupListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public GroupListBuilder() {
        this(true);
    }

    public GroupListBuilder(Boolean validationEnabled) {
        this(new GroupList(), validationEnabled);
    }

    public GroupListBuilder(GroupListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public GroupListBuilder(GroupListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new GroupList(), validationEnabled);
    }

    public GroupListBuilder(GroupListFluent<?> fluent, GroupList instance) {
        this(fluent, instance, true);
    }

    public GroupListBuilder(GroupListFluent<?> fluent, GroupList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public GroupListBuilder(GroupList instance) {
        this(instance, (Boolean)true);
    }

    public GroupListBuilder(GroupList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public GroupListBuilder(Validator validator) {
        this(new GroupList(), (Boolean)true);
    }

    public GroupListBuilder(GroupListFluent<?> fluent, GroupList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public GroupListBuilder(GroupList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public GroupList build() {
        GroupList buildable = new GroupList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupListBuilder that = (GroupListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

