/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ExecConfig;
import io.fabric8.kubernetes.api.model.ExecConfigFluent;
import io.fabric8.kubernetes.api.model.ExecEnvVar;
import io.fabric8.kubernetes.api.model.ExecEnvVarBuilder;
import io.fabric8.kubernetes.api.model.ExecEnvVarFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ExecConfigFluentImpl<A extends ExecConfigFluent<A>>
extends BaseFluent<A>
implements ExecConfigFluent<A> {
    private String apiVersion;
    private List<String> args = new ArrayList<String>();
    private String command;
    private List<ExecEnvVarBuilder> env = new ArrayList<ExecEnvVarBuilder>();
    private String installHint;

    public ExecConfigFluentImpl() {
    }

    public ExecConfigFluentImpl(ExecConfig instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withArgs(instance.getArgs());
        this.withCommand(instance.getCommand());
        this.withEnv(instance.getEnv());
        this.withInstallHint(instance.getInstallHint());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToArgs(int index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(index, item);
        return (A)this;
    }

    @Override
    public A setToArgs(int index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.set(index, item);
        return (A)this;
    }

    @Override
    public A addToArgs(String ... items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToArgs(Collection<String> items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromArgs(String ... items) {
        for (String item : items) {
            if (this.args == null) continue;
            this.args.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromArgs(Collection<String> items) {
        for (String item : items) {
            if (this.args == null) continue;
            this.args.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getArgs() {
        return this.args;
    }

    @Override
    public String getArg(int index) {
        return this.args.get(index);
    }

    @Override
    public String getFirstArg() {
        return this.args.get(0);
    }

    @Override
    public String getLastArg() {
        return this.args.get(this.args.size() - 1);
    }

    @Override
    public String getMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withArgs(List<String> args) {
        if (this.args != null) {
            this._visitables.get("args").removeAll(this.args);
        }
        if (args != null) {
            this.args = new ArrayList<String>();
            for (String item : args) {
                this.addToArgs(item);
            }
        } else {
            this.args = null;
        }
        return (A)this;
    }

    @Override
    public A withArgs(String ... args) {
        if (this.args != null) {
            this.args.clear();
        }
        if (args != null) {
            for (String item : args) {
                this.addToArgs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasArgs() {
        return this.args != null && !this.args.isEmpty();
    }

    @Override
    public A addNewArg(String arg1) {
        return this.addToArgs(new String(arg1));
    }

    @Override
    public A addNewArg(StringBuilder arg1) {
        return this.addToArgs(new String(arg1));
    }

    @Override
    public A addNewArg(StringBuffer arg1) {
        return this.addToArgs(new String(arg1));
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public A withCommand(String command) {
        this.command = command;
        return (A)this;
    }

    @Override
    public Boolean hasCommand() {
        return this.command != null;
    }

    @Override
    public A withNewCommand(String arg1) {
        return this.withCommand(new String(arg1));
    }

    @Override
    public A withNewCommand(StringBuilder arg1) {
        return this.withCommand(new String(arg1));
    }

    @Override
    public A withNewCommand(StringBuffer arg1) {
        return this.withCommand(new String(arg1));
    }

    @Override
    public A addToEnv(int index, ExecEnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<ExecEnvVarBuilder>();
        }
        ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);
        this._visitables.get("env").add(index >= 0 ? index : this._visitables.get("env").size(), builder);
        this.env.add(index >= 0 ? index : this.env.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnv(int index, ExecEnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<ExecEnvVarBuilder>();
        }
        ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);
        if (index < 0 || index >= this._visitables.get("env").size()) {
            this._visitables.get("env").add(builder);
        } else {
            this._visitables.get("env").set(index, builder);
        }
        if (index < 0 || index >= this.env.size()) {
            this.env.add(builder);
        } else {
            this.env.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnv(ExecEnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList<ExecEnvVarBuilder>();
        }
        for (ExecEnvVar item : items) {
            ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnv(Collection<ExecEnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList<ExecEnvVarBuilder>();
        }
        for (ExecEnvVar item : items) {
            ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(ExecEnvVar ... items) {
        for (ExecEnvVar item : items) {
            ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);
            this._visitables.get("env").remove(builder);
            if (this.env == null) continue;
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnv(Collection<ExecEnvVar> items) {
        for (ExecEnvVar item : items) {
            ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);
            this._visitables.get("env").remove(builder);
            if (this.env == null) continue;
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEnv(Predicate<ExecEnvVarBuilder> predicate) {
        if (this.env == null) {
            return (A)this;
        }
        Iterator<ExecEnvVarBuilder> each = this.env.iterator();
        Object visitables = this._visitables.get("env");
        while (each.hasNext()) {
            ExecEnvVarBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ExecEnvVar> getEnv() {
        return ExecConfigFluentImpl.build(this.env);
    }

    @Override
    public List<ExecEnvVar> buildEnv() {
        return ExecConfigFluentImpl.build(this.env);
    }

    @Override
    public ExecEnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    @Override
    public ExecEnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    @Override
    public ExecEnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    @Override
    public ExecEnvVar buildMatchingEnv(Predicate<ExecEnvVarBuilder> predicate) {
        for (ExecEnvVarBuilder item : this.env) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnv(Predicate<ExecEnvVarBuilder> predicate) {
        for (ExecEnvVarBuilder item : this.env) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnv(List<ExecEnvVar> env) {
        if (this.env != null) {
            this._visitables.get("env").removeAll(this.env);
        }
        if (env != null) {
            this.env = new ArrayList<ExecEnvVarBuilder>();
            for (ExecEnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)this;
    }

    @Override
    public A withEnv(ExecEnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
        }
        if (env != null) {
            for (ExecEnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    @Override
    public A addNewEnv(String name, String value) {
        return this.addToEnv(new ExecEnvVar(name, value));
    }

    @Override
    public ExecConfigFluent.EnvNested<A> addNewEnv() {
        return new EnvNestedImpl();
    }

    @Override
    public ExecConfigFluent.EnvNested<A> addNewEnvLike(ExecEnvVar item) {
        return new EnvNestedImpl(-1, item);
    }

    @Override
    public ExecConfigFluent.EnvNested<A> setNewEnvLike(int index, ExecEnvVar item) {
        return new EnvNestedImpl(index, item);
    }

    @Override
    public ExecConfigFluent.EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public ExecConfigFluent.EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    @Override
    public ExecConfigFluent.EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public ExecConfigFluent.EnvNested<A> editMatchingEnv(Predicate<ExecEnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.apply(this.env.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public String getInstallHint() {
        return this.installHint;
    }

    @Override
    public A withInstallHint(String installHint) {
        this.installHint = installHint;
        return (A)this;
    }

    @Override
    public Boolean hasInstallHint() {
        return this.installHint != null;
    }

    @Override
    public A withNewInstallHint(String arg1) {
        return this.withInstallHint(new String(arg1));
    }

    @Override
    public A withNewInstallHint(StringBuilder arg1) {
        return this.withInstallHint(new String(arg1));
    }

    @Override
    public A withNewInstallHint(StringBuffer arg1) {
        return this.withInstallHint(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecConfigFluentImpl that = (ExecConfigFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.args != null ? !this.args.equals(that.args) : that.args != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        return !(this.installHint != null ? !this.installHint.equals(that.installHint) : that.installHint != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.args, this.command, this.env, this.installHint, super.hashCode());
    }

    public class EnvNestedImpl<N>
    extends ExecEnvVarFluentImpl<ExecConfigFluent.EnvNested<N>>
    implements ExecConfigFluent.EnvNested<N>,
    Nested<N> {
        private final ExecEnvVarBuilder builder;
        private final int index;

        EnvNestedImpl(int index, ExecEnvVar item) {
            this.index = index;
            this.builder = new ExecEnvVarBuilder(this, item);
        }

        EnvNestedImpl() {
            this.index = -1;
            this.builder = new ExecEnvVarBuilder(this);
        }

        @Override
        public N and() {
            return (N)ExecConfigFluentImpl.this.setToEnv(this.index, this.builder.build());
        }

        @Override
        public N endEnv() {
            return this.and();
        }
    }
}

