/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesFluentImpl;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfig;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNS;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNSBuilder;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNSFluentImpl;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class StaticIPAMConfigFluentImpl<A extends StaticIPAMConfigFluent<A>>
extends BaseFluent<A>
implements StaticIPAMConfigFluent<A> {
    private List<StaticIPAMAddressesBuilder> addresses = new ArrayList<StaticIPAMAddressesBuilder>();
    private StaticIPAMDNSBuilder dns;
    private List<StaticIPAMRoutesBuilder> routes = new ArrayList<StaticIPAMRoutesBuilder>();

    public StaticIPAMConfigFluentImpl() {
    }

    public StaticIPAMConfigFluentImpl(StaticIPAMConfig instance) {
        this.withAddresses(instance.getAddresses());
        this.withDns(instance.getDns());
        this.withRoutes(instance.getRoutes());
    }

    @Override
    public A addToAddresses(int index, StaticIPAMAddresses item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<StaticIPAMAddressesBuilder>();
        }
        StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);
        this._visitables.get("addresses").add(index >= 0 ? index : this._visitables.get("addresses").size(), builder);
        this.addresses.add(index >= 0 ? index : this.addresses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAddresses(int index, StaticIPAMAddresses item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<StaticIPAMAddressesBuilder>();
        }
        StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);
        if (index < 0 || index >= this._visitables.get("addresses").size()) {
            this._visitables.get("addresses").add(builder);
        } else {
            this._visitables.get("addresses").set(index, builder);
        }
        if (index < 0 || index >= this.addresses.size()) {
            this.addresses.add(builder);
        } else {
            this.addresses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAddresses(StaticIPAMAddresses ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<StaticIPAMAddressesBuilder>();
        }
        for (StaticIPAMAddresses item : items) {
            StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddresses(Collection<StaticIPAMAddresses> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<StaticIPAMAddressesBuilder>();
        }
        for (StaticIPAMAddresses item : items) {
            StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(StaticIPAMAddresses ... items) {
        for (StaticIPAMAddresses item : items) {
            StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddresses(Collection<StaticIPAMAddresses> items) {
        for (StaticIPAMAddresses item : items) {
            StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAddresses(Predicate<StaticIPAMAddressesBuilder> predicate) {
        if (this.addresses == null) {
            return (A)this;
        }
        Iterator<StaticIPAMAddressesBuilder> each = this.addresses.iterator();
        Object visitables = this._visitables.get("addresses");
        while (each.hasNext()) {
            StaticIPAMAddressesBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<StaticIPAMAddresses> getAddresses() {
        return StaticIPAMConfigFluentImpl.build(this.addresses);
    }

    @Override
    public List<StaticIPAMAddresses> buildAddresses() {
        return StaticIPAMConfigFluentImpl.build(this.addresses);
    }

    @Override
    public StaticIPAMAddresses buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    @Override
    public StaticIPAMAddresses buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    @Override
    public StaticIPAMAddresses buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    @Override
    public StaticIPAMAddresses buildMatchingAddress(Predicate<StaticIPAMAddressesBuilder> predicate) {
        for (StaticIPAMAddressesBuilder item : this.addresses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAddress(Predicate<StaticIPAMAddressesBuilder> predicate) {
        for (StaticIPAMAddressesBuilder item : this.addresses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAddresses(List<StaticIPAMAddresses> addresses) {
        if (this.addresses != null) {
            this._visitables.get("addresses").removeAll(this.addresses);
        }
        if (addresses != null) {
            this.addresses = new ArrayList<StaticIPAMAddressesBuilder>();
            for (StaticIPAMAddresses item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    @Override
    public A withAddresses(StaticIPAMAddresses ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
        }
        if (addresses != null) {
            for (StaticIPAMAddresses item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    @Override
    public A addNewAddress(String address, String gateway) {
        return this.addToAddresses(new StaticIPAMAddresses(address, gateway));
    }

    @Override
    public StaticIPAMConfigFluent.AddressesNested<A> addNewAddress() {
        return new AddressesNestedImpl();
    }

    @Override
    public StaticIPAMConfigFluent.AddressesNested<A> addNewAddressLike(StaticIPAMAddresses item) {
        return new AddressesNestedImpl(-1, item);
    }

    @Override
    public StaticIPAMConfigFluent.AddressesNested<A> setNewAddressLike(int index, StaticIPAMAddresses item) {
        return new AddressesNestedImpl(index, item);
    }

    @Override
    public StaticIPAMConfigFluent.AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public StaticIPAMConfigFluent.AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    @Override
    public StaticIPAMConfigFluent.AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public StaticIPAMConfigFluent.AddressesNested<A> editMatchingAddress(Predicate<StaticIPAMAddressesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.apply(this.addresses.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    @Deprecated
    public StaticIPAMDNS getDns() {
        return this.dns != null ? this.dns.build() : null;
    }

    @Override
    public StaticIPAMDNS buildDns() {
        return this.dns != null ? this.dns.build() : null;
    }

    @Override
    public A withDns(StaticIPAMDNS dns) {
        this._visitables.get("dns").remove(this.dns);
        if (dns != null) {
            this.dns = new StaticIPAMDNSBuilder(dns);
            this._visitables.get("dns").add(this.dns);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDns() {
        return this.dns != null;
    }

    @Override
    public StaticIPAMConfigFluent.DnsNested<A> withNewDns() {
        return new DnsNestedImpl();
    }

    @Override
    public StaticIPAMConfigFluent.DnsNested<A> withNewDnsLike(StaticIPAMDNS item) {
        return new DnsNestedImpl(item);
    }

    @Override
    public StaticIPAMConfigFluent.DnsNested<A> editDns() {
        return this.withNewDnsLike(this.getDns());
    }

    @Override
    public StaticIPAMConfigFluent.DnsNested<A> editOrNewDns() {
        return this.withNewDnsLike(this.getDns() != null ? this.getDns() : new StaticIPAMDNSBuilder().build());
    }

    @Override
    public StaticIPAMConfigFluent.DnsNested<A> editOrNewDnsLike(StaticIPAMDNS item) {
        return this.withNewDnsLike(this.getDns() != null ? this.getDns() : item);
    }

    @Override
    public A addToRoutes(int index, StaticIPAMRoutes item) {
        if (this.routes == null) {
            this.routes = new ArrayList<StaticIPAMRoutesBuilder>();
        }
        StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);
        this._visitables.get("routes").add(index >= 0 ? index : this._visitables.get("routes").size(), builder);
        this.routes.add(index >= 0 ? index : this.routes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRoutes(int index, StaticIPAMRoutes item) {
        if (this.routes == null) {
            this.routes = new ArrayList<StaticIPAMRoutesBuilder>();
        }
        StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);
        if (index < 0 || index >= this._visitables.get("routes").size()) {
            this._visitables.get("routes").add(builder);
        } else {
            this._visitables.get("routes").set(index, builder);
        }
        if (index < 0 || index >= this.routes.size()) {
            this.routes.add(builder);
        } else {
            this.routes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRoutes(StaticIPAMRoutes ... items) {
        if (this.routes == null) {
            this.routes = new ArrayList<StaticIPAMRoutesBuilder>();
        }
        for (StaticIPAMRoutes item : items) {
            StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);
            this._visitables.get("routes").add(builder);
            this.routes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRoutes(Collection<StaticIPAMRoutes> items) {
        if (this.routes == null) {
            this.routes = new ArrayList<StaticIPAMRoutesBuilder>();
        }
        for (StaticIPAMRoutes item : items) {
            StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);
            this._visitables.get("routes").add(builder);
            this.routes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRoutes(StaticIPAMRoutes ... items) {
        for (StaticIPAMRoutes item : items) {
            StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);
            this._visitables.get("routes").remove(builder);
            if (this.routes == null) continue;
            this.routes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRoutes(Collection<StaticIPAMRoutes> items) {
        for (StaticIPAMRoutes item : items) {
            StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);
            this._visitables.get("routes").remove(builder);
            if (this.routes == null) continue;
            this.routes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRoutes(Predicate<StaticIPAMRoutesBuilder> predicate) {
        if (this.routes == null) {
            return (A)this;
        }
        Iterator<StaticIPAMRoutesBuilder> each = this.routes.iterator();
        Object visitables = this._visitables.get("routes");
        while (each.hasNext()) {
            StaticIPAMRoutesBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<StaticIPAMRoutes> getRoutes() {
        return StaticIPAMConfigFluentImpl.build(this.routes);
    }

    @Override
    public List<StaticIPAMRoutes> buildRoutes() {
        return StaticIPAMConfigFluentImpl.build(this.routes);
    }

    @Override
    public StaticIPAMRoutes buildRoute(int index) {
        return this.routes.get(index).build();
    }

    @Override
    public StaticIPAMRoutes buildFirstRoute() {
        return this.routes.get(0).build();
    }

    @Override
    public StaticIPAMRoutes buildLastRoute() {
        return this.routes.get(this.routes.size() - 1).build();
    }

    @Override
    public StaticIPAMRoutes buildMatchingRoute(Predicate<StaticIPAMRoutesBuilder> predicate) {
        for (StaticIPAMRoutesBuilder item : this.routes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRoute(Predicate<StaticIPAMRoutesBuilder> predicate) {
        for (StaticIPAMRoutesBuilder item : this.routes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRoutes(List<StaticIPAMRoutes> routes) {
        if (this.routes != null) {
            this._visitables.get("routes").removeAll(this.routes);
        }
        if (routes != null) {
            this.routes = new ArrayList<StaticIPAMRoutesBuilder>();
            for (StaticIPAMRoutes item : routes) {
                this.addToRoutes(item);
            }
        } else {
            this.routes = null;
        }
        return (A)this;
    }

    @Override
    public A withRoutes(StaticIPAMRoutes ... routes) {
        if (this.routes != null) {
            this.routes.clear();
        }
        if (routes != null) {
            for (StaticIPAMRoutes item : routes) {
                this.addToRoutes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoutes() {
        return this.routes != null && !this.routes.isEmpty();
    }

    @Override
    public A addNewRoute(String destination, String gateway) {
        return this.addToRoutes(new StaticIPAMRoutes(destination, gateway));
    }

    @Override
    public StaticIPAMConfigFluent.RoutesNested<A> addNewRoute() {
        return new RoutesNestedImpl();
    }

    @Override
    public StaticIPAMConfigFluent.RoutesNested<A> addNewRouteLike(StaticIPAMRoutes item) {
        return new RoutesNestedImpl(-1, item);
    }

    @Override
    public StaticIPAMConfigFluent.RoutesNested<A> setNewRouteLike(int index, StaticIPAMRoutes item) {
        return new RoutesNestedImpl(index, item);
    }

    @Override
    public StaticIPAMConfigFluent.RoutesNested<A> editRoute(int index) {
        if (this.routes.size() <= index) {
            throw new RuntimeException("Can't edit routes. Index exceeds size.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    @Override
    public StaticIPAMConfigFluent.RoutesNested<A> editFirstRoute() {
        if (this.routes.size() == 0) {
            throw new RuntimeException("Can't edit first routes. The list is empty.");
        }
        return this.setNewRouteLike(0, this.buildRoute(0));
    }

    @Override
    public StaticIPAMConfigFluent.RoutesNested<A> editLastRoute() {
        int index = this.routes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last routes. The list is empty.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    @Override
    public StaticIPAMConfigFluent.RoutesNested<A> editMatchingRoute(Predicate<StaticIPAMRoutesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.routes.size(); ++i) {
            if (!predicate.apply(this.routes.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching routes. No match found.");
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticIPAMConfigFluentImpl that = (StaticIPAMConfigFluentImpl)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.dns != null ? !this.dns.equals(that.dns) : that.dns != null) {
            return false;
        }
        return !(this.routes != null ? !this.routes.equals(that.routes) : that.routes != null);
    }

    public class RoutesNestedImpl<N>
    extends StaticIPAMRoutesFluentImpl<StaticIPAMConfigFluent.RoutesNested<N>>
    implements StaticIPAMConfigFluent.RoutesNested<N>,
    Nested<N> {
        private final StaticIPAMRoutesBuilder builder;
        private final int index;

        RoutesNestedImpl(int index, StaticIPAMRoutes item) {
            this.index = index;
            this.builder = new StaticIPAMRoutesBuilder(this, item);
        }

        RoutesNestedImpl() {
            this.index = -1;
            this.builder = new StaticIPAMRoutesBuilder(this);
        }

        @Override
        public N and() {
            return (N)StaticIPAMConfigFluentImpl.this.setToRoutes(this.index, this.builder.build());
        }

        @Override
        public N endRoute() {
            return this.and();
        }
    }

    public class DnsNestedImpl<N>
    extends StaticIPAMDNSFluentImpl<StaticIPAMConfigFluent.DnsNested<N>>
    implements StaticIPAMConfigFluent.DnsNested<N>,
    Nested<N> {
        private final StaticIPAMDNSBuilder builder;

        DnsNestedImpl(StaticIPAMDNS item) {
            this.builder = new StaticIPAMDNSBuilder(this, item);
        }

        DnsNestedImpl() {
            this.builder = new StaticIPAMDNSBuilder(this);
        }

        @Override
        public N and() {
            return (N)StaticIPAMConfigFluentImpl.this.withDns(this.builder.build());
        }

        @Override
        public N endDns() {
            return this.and();
        }
    }

    public class AddressesNestedImpl<N>
    extends StaticIPAMAddressesFluentImpl<StaticIPAMConfigFluent.AddressesNested<N>>
    implements StaticIPAMConfigFluent.AddressesNested<N>,
    Nested<N> {
        private final StaticIPAMAddressesBuilder builder;
        private final int index;

        AddressesNestedImpl(int index, StaticIPAMAddresses item) {
            this.index = index;
            this.builder = new StaticIPAMAddressesBuilder(this, item);
        }

        AddressesNestedImpl() {
            this.index = -1;
            this.builder = new StaticIPAMAddressesBuilder(this);
        }

        @Override
        public N and() {
            return (N)StaticIPAMConfigFluentImpl.this.setToAddresses(this.index, this.builder.build());
        }

        @Override
        public N endAddress() {
            return this.and();
        }
    }
}

