/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.batch.v1;

import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.autoscaling.v1.Scale;
import io.fabric8.kubernetes.api.model.batch.DoneableJob;
import io.fabric8.kubernetes.api.model.batch.Job;
import io.fabric8.kubernetes.api.model.batch.JobFluent;
import io.fabric8.kubernetes.api.model.batch.JobList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobOperationsImpl
extends HasMetadataOperation<Job, JobList, DoneableJob, ScalableResource<Job, DoneableJob>>
implements ScalableResource<Job, DoneableJob> {
    static final transient Logger LOG = LoggerFactory.getLogger(JobOperationsImpl.class);

    public JobOperationsImpl(OkHttpClient client, Config config) {
        this(client, config, null);
    }

    public JobOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
    }

    public JobOperationsImpl(OperationContext context) {
        super(context.withApiGroupName("batch").withApiGroupVersion("v1").withPlural("jobs"));
        this.type = Job.class;
        this.listType = JobList.class;
        this.doneableType = DoneableJob.class;
    }

    public JobOperationsImpl newInstance(OperationContext context) {
        return new JobOperationsImpl(context);
    }

    @Override
    public ScalableResource<Job, DoneableJob> load(InputStream is) {
        try {
            Job item = JobOperationsImpl.unmarshal(is, Job.class);
            return new JobOperationsImpl(this.context.withItem(item));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public ScalableResource<Job, DoneableJob> fromServer() {
        return new JobOperationsImpl(this.context.withReloadingFromServer(true));
    }

    @Override
    public Job scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public Scale scale() {
        return this.handleScale(null);
    }

    @Override
    public Scale scale(Scale scale) {
        return this.handleScale(scale);
    }

    @Override
    public Job scale(int count, boolean wait) {
        Job res = ((DoneableJob)((JobFluent.SpecNested)((DoneableJob)this.cascading(false).edit()).editSpec().withParallelism(count)).endSpec()).done();
        if (wait) {
            this.waitUntilJobIsScaled();
            res = (Job)this.getMandatory();
        }
        return res;
    }

    private void waitUntilJobIsScaled() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference atomicJob = new AtomicReference();
        Runnable jobPoller = () -> {
            try {
                Job job = (Job)this.getMandatory();
                atomicJob.set(job);
                Integer activeJobs = job.getStatus().getActive();
                if (activeJobs == null) {
                    activeJobs = 0;
                }
                if (Objects.equals(job.getSpec().getParallelism(), activeJobs)) {
                    countDownLatch.countDown();
                } else {
                    LOG.debug("Only {}/{} pods scheduled for Job: {} in namespace: {} seconds so waiting...", new Object[]{job.getStatus().getActive(), job.getSpec().getParallelism(), job.getMetadata().getName(), this.namespace});
                }
            }
            catch (Throwable t) {
                LOG.error("Error while waiting for Job to be scaled.", t);
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(jobPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            countDownLatch.await(this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS);
            executor.shutdown();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            poller.cancel(true);
            executor.shutdown();
            LOG.error("Only {}/{} pod(s) ready for Job: {} in namespace: {} - giving up", new Object[]{((Job)atomicJob.get()).getStatus().getActive(), ((Job)atomicJob.get()).getSpec().getParallelism(), ((Job)atomicJob.get()).getMetadata().getName(), this.namespace});
        }
    }

    @Override
    public String getLog() {
        return this.getLog(false);
    }

    @Override
    public String getLog(Boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<PodResource<Pod, DoneablePod>> podOperationList = this.doGetLog(false);
        for (PodResource<Pod, DoneablePod> podOperation : podOperationList) {
            stringBuilder.append((String)podOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<PodResource<Pod, DoneablePod>> doGetLog(boolean isPretty) {
        ArrayList<PodResource<Pod, DoneablePod>> pods = new ArrayList<PodResource<Pod, DoneablePod>>();
        Job job = (Job)this.fromServer().get();
        String jobUid = job.getMetadata().getUid();
        PodOperationsImpl podOperations = new PodOperationsImpl(new PodOperationContext(this.context.getClient(), this.context.getConfig(), this.context.getPlural(), this.context.getNamespace(), null, null, "v1", this.context.getCascading(), this.context.getItem(), this.context.getLabels(), this.context.getLabelsNot(), this.context.getLabelsIn(), this.context.getLabelsNotIn(), this.context.getFields(), this.context.getFieldsNot(), this.context.getResourceVersion(), this.context.getReloadingFromServer(), this.context.getGracePeriodSeconds(), this.context.getPropagationPolicy(), this.context.getWatchRetryInitialBackoffMillis(), this.context.getWatchRetryBackoffMultiplier(), null, null, null, null, null, null, null, null, null, false, false, false, null, null, null, isPretty, null, null, null, null, null));
        PodList jobPodList = (PodList)podOperations.withLabel("controller-uid", jobUid).list();
        for (Pod pod : jobPodList.getItems()) {
            OwnerReference ownerReference = KubernetesResourceUtil.getControllerUid(pod);
            if (ownerReference == null || !ownerReference.getUid().equals(jobUid)) continue;
            pods.add((PodResource)podOperations.withName(pod.getMetadata().getName()));
        }
        return pods;
    }

    @Override
    public Reader getLogReader() {
        List<PodResource<Pod, DoneablePod>> podResources = this.doGetLog(false);
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Reading logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return podResources.get(0).getLogReader();
        }
        return null;
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        List<PodResource<Pod, DoneablePod>> podResources = this.doGetLog(false);
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Watching logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return (LogWatch)podResources.get(0).watchLog(out);
        }
        return null;
    }

    @Override
    public Job replace(Job job) {
        if (job == null) {
            job = (Job)this.getItem();
        }
        Job jobFromServer = (Job)this.fromServer().get();
        if (job.getSpec().getSelector() == null) {
            job.getSpec().setSelector(jobFromServer.getSpec().getSelector());
        }
        if (job.getSpec().getTemplate().getMetadata() != null) {
            job.getSpec().getTemplate().getMetadata().setLabels(jobFromServer.getSpec().getTemplate().getMetadata().getLabels());
        } else {
            job.getSpec().getTemplate().setMetadata(jobFromServer.getSpec().getTemplate().getMetadata());
        }
        return super.replace(job);
    }
}

