/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook;
import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfiguration;
import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent;
import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ValidatingWebhookConfigurationFluentImpl<A extends ValidatingWebhookConfigurationFluent<A>>
extends BaseFluent<A>
implements ValidatingWebhookConfigurationFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<ValidatingWebhookBuilder> webhooks = new ArrayList<ValidatingWebhookBuilder>();

    public ValidatingWebhookConfigurationFluentImpl() {
    }

    public ValidatingWebhookConfigurationFluentImpl(ValidatingWebhookConfiguration instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withWebhooks(instance.getWebhooks());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ValidatingWebhookConfigurationFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ValidatingWebhookConfigurationFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ValidatingWebhookConfigurationFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ValidatingWebhookConfigurationFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ValidatingWebhookConfigurationFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToWebhooks(int index, ValidatingWebhook item) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList<ValidatingWebhookBuilder>();
        }
        ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);
        this._visitables.get("webhooks").add(index >= 0 ? index : this._visitables.get("webhooks").size(), builder);
        this.webhooks.add(index >= 0 ? index : this.webhooks.size(), builder);
        return (A)this;
    }

    @Override
    public A setToWebhooks(int index, ValidatingWebhook item) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList<ValidatingWebhookBuilder>();
        }
        ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);
        if (index < 0 || index >= this._visitables.get("webhooks").size()) {
            this._visitables.get("webhooks").add(builder);
        } else {
            this._visitables.get("webhooks").set(index, builder);
        }
        if (index < 0 || index >= this.webhooks.size()) {
            this.webhooks.add(builder);
        } else {
            this.webhooks.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToWebhooks(ValidatingWebhook ... items) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList<ValidatingWebhookBuilder>();
        }
        for (ValidatingWebhook item : items) {
            ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);
            this._visitables.get("webhooks").add(builder);
            this.webhooks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToWebhooks(Collection<ValidatingWebhook> items) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList<ValidatingWebhookBuilder>();
        }
        for (ValidatingWebhook item : items) {
            ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);
            this._visitables.get("webhooks").add(builder);
            this.webhooks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromWebhooks(ValidatingWebhook ... items) {
        for (ValidatingWebhook item : items) {
            ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);
            this._visitables.get("webhooks").remove(builder);
            if (this.webhooks == null) continue;
            this.webhooks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromWebhooks(Collection<ValidatingWebhook> items) {
        for (ValidatingWebhook item : items) {
            ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);
            this._visitables.get("webhooks").remove(builder);
            if (this.webhooks == null) continue;
            this.webhooks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromWebhooks(Predicate<ValidatingWebhookBuilder> predicate) {
        if (this.webhooks == null) {
            return (A)this;
        }
        Iterator<ValidatingWebhookBuilder> each = this.webhooks.iterator();
        Object visitables = this._visitables.get("webhooks");
        while (each.hasNext()) {
            ValidatingWebhookBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ValidatingWebhook> getWebhooks() {
        return ValidatingWebhookConfigurationFluentImpl.build(this.webhooks);
    }

    @Override
    public List<ValidatingWebhook> buildWebhooks() {
        return ValidatingWebhookConfigurationFluentImpl.build(this.webhooks);
    }

    @Override
    public ValidatingWebhook buildWebhook(int index) {
        return this.webhooks.get(index).build();
    }

    @Override
    public ValidatingWebhook buildFirstWebhook() {
        return this.webhooks.get(0).build();
    }

    @Override
    public ValidatingWebhook buildLastWebhook() {
        return this.webhooks.get(this.webhooks.size() - 1).build();
    }

    @Override
    public ValidatingWebhook buildMatchingWebhook(Predicate<ValidatingWebhookBuilder> predicate) {
        for (ValidatingWebhookBuilder item : this.webhooks) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingWebhook(Predicate<ValidatingWebhookBuilder> predicate) {
        for (ValidatingWebhookBuilder item : this.webhooks) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withWebhooks(List<ValidatingWebhook> webhooks) {
        if (this.webhooks != null) {
            this._visitables.get("webhooks").removeAll(this.webhooks);
        }
        if (webhooks != null) {
            this.webhooks = new ArrayList<ValidatingWebhookBuilder>();
            for (ValidatingWebhook item : webhooks) {
                this.addToWebhooks(item);
            }
        } else {
            this.webhooks = null;
        }
        return (A)this;
    }

    @Override
    public A withWebhooks(ValidatingWebhook ... webhooks) {
        if (this.webhooks != null) {
            this.webhooks.clear();
        }
        if (webhooks != null) {
            for (ValidatingWebhook item : webhooks) {
                this.addToWebhooks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasWebhooks() {
        return this.webhooks != null && !this.webhooks.isEmpty();
    }

    @Override
    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> addNewWebhook() {
        return new WebhooksNestedImpl();
    }

    @Override
    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> addNewWebhookLike(ValidatingWebhook item) {
        return new WebhooksNestedImpl(-1, item);
    }

    @Override
    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> setNewWebhookLike(int index, ValidatingWebhook item) {
        return new WebhooksNestedImpl(index, item);
    }

    @Override
    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> editWebhook(int index) {
        if (this.webhooks.size() <= index) {
            throw new RuntimeException("Can't edit webhooks. Index exceeds size.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    @Override
    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> editFirstWebhook() {
        if (this.webhooks.size() == 0) {
            throw new RuntimeException("Can't edit first webhooks. The list is empty.");
        }
        return this.setNewWebhookLike(0, this.buildWebhook(0));
    }

    @Override
    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> editLastWebhook() {
        int index = this.webhooks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last webhooks. The list is empty.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    @Override
    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> editMatchingWebhook(Predicate<ValidatingWebhookBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.webhooks.size(); ++i) {
            if (!predicate.apply(this.webhooks.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching webhooks. No match found.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidatingWebhookConfigurationFluentImpl that = (ValidatingWebhookConfigurationFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.webhooks != null ? !this.webhooks.equals(that.webhooks) : that.webhooks != null);
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ValidatingWebhookConfigurationFluent.MetadataNested<N>>
    implements ValidatingWebhookConfigurationFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ValidatingWebhookConfigurationFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class WebhooksNestedImpl<N>
    extends ValidatingWebhookFluentImpl<ValidatingWebhookConfigurationFluent.WebhooksNested<N>>
    implements ValidatingWebhookConfigurationFluent.WebhooksNested<N>,
    Nested<N> {
        private final ValidatingWebhookBuilder builder;
        private final int index;

        WebhooksNestedImpl(int index, ValidatingWebhook item) {
            this.index = index;
            this.builder = new ValidatingWebhookBuilder(this, item);
        }

        WebhooksNestedImpl() {
            this.index = -1;
            this.builder = new ValidatingWebhookBuilder(this);
        }

        @Override
        public N and() {
            return (N)ValidatingWebhookConfigurationFluentImpl.this.setToWebhooks(this.index, this.builder.build());
        }

        @Override
        public N endWebhook() {
            return this.and();
        }
    }
}

