/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSource;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSourceFluent;

public class PodsMetricSourceFluentImpl<A extends PodsMetricSourceFluent<A>>
extends BaseFluent<A>
implements PodsMetricSourceFluent<A> {
    private String metricName;
    private LabelSelectorBuilder selector;
    private Quantity targetAverageValue;

    public PodsMetricSourceFluentImpl() {
    }

    public PodsMetricSourceFluentImpl(PodsMetricSource instance) {
        this.withMetricName(instance.getMetricName());
        this.withSelector(instance.getSelector());
        this.withTargetAverageValue(instance.getTargetAverageValue());
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)this;
    }

    @Override
    public Boolean hasMetricName() {
        return this.metricName != null;
    }

    @Override
    public A withNewMetricName(String arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    public A withNewMetricName(StringBuilder arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    public A withNewMetricName(StringBuffer arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public PodsMetricSourceFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public PodsMetricSourceFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public PodsMetricSourceFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public PodsMetricSourceFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public PodsMetricSourceFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public Quantity getTargetAverageValue() {
        return this.targetAverageValue;
    }

    @Override
    public A withTargetAverageValue(Quantity targetAverageValue) {
        this.targetAverageValue = targetAverageValue;
        return (A)this;
    }

    @Override
    public Boolean hasTargetAverageValue() {
        return this.targetAverageValue != null;
    }

    @Override
    public A withNewTargetAverageValue(String amount, String format) {
        return this.withTargetAverageValue(new Quantity(amount, format));
    }

    @Override
    public A withNewTargetAverageValue(String amount) {
        return this.withTargetAverageValue(new Quantity(amount));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodsMetricSourceFluentImpl that = (PodsMetricSourceFluentImpl)o;
        if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        return !(this.targetAverageValue != null ? !this.targetAverageValue.equals(that.targetAverageValue) : that.targetAverageValue != null);
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<PodsMetricSourceFluent.SelectorNested<N>>
    implements PodsMetricSourceFluent.SelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodsMetricSourceFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

