/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.rbac.KubernetesSubject;
import io.fabric8.kubernetes.api.model.rbac.KubernetesSubjectFluent;
import io.fabric8.kubernetes.api.model.rbac.KubernetesSubjectFluentImpl;

public class KubernetesSubjectBuilder
extends KubernetesSubjectFluentImpl<KubernetesSubjectBuilder>
implements VisitableBuilder<KubernetesSubject, KubernetesSubjectBuilder> {
    KubernetesSubjectFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesSubjectBuilder() {
        this(true);
    }

    public KubernetesSubjectBuilder(Boolean validationEnabled) {
        this(new KubernetesSubject(), validationEnabled);
    }

    public KubernetesSubjectBuilder(KubernetesSubjectFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KubernetesSubjectBuilder(KubernetesSubjectFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KubernetesSubject(), validationEnabled);
    }

    public KubernetesSubjectBuilder(KubernetesSubjectFluent<?> fluent, KubernetesSubject instance) {
        this(fluent, instance, true);
    }

    public KubernetesSubjectBuilder(KubernetesSubjectFluent<?> fluent, KubernetesSubject instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiGroup(instance.getApiGroup());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesSubjectBuilder(KubernetesSubject instance) {
        this(instance, (Boolean)true);
    }

    public KubernetesSubjectBuilder(KubernetesSubject instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiGroup(instance.getApiGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public KubernetesSubject build() {
        KubernetesSubject buildable = new KubernetesSubject(this.fluent.getApiGroup(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getNamespace());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesSubjectBuilder that = (KubernetesSubjectBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

