/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_0.authentication;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import io.fabric8.kubernetes.api.model.v4_0.authentication.TokenReviewStatus;
import io.fabric8.kubernetes.api.model.v4_0.authentication.TokenReviewStatusFluent;
import io.fabric8.kubernetes.api.model.v4_0.authentication.UserInfo;
import io.fabric8.kubernetes.api.model.v4_0.authentication.UserInfoBuilder;
import io.fabric8.kubernetes.api.model.v4_0.authentication.UserInfoFluentImpl;

public class TokenReviewStatusFluentImpl<A extends TokenReviewStatusFluent<A>>
extends BaseFluent<A>
implements TokenReviewStatusFluent<A> {
    private Boolean authenticated;
    private String error;
    private UserInfoBuilder user;

    public TokenReviewStatusFluentImpl() {
    }

    public TokenReviewStatusFluentImpl(TokenReviewStatus instance) {
        this.withAuthenticated(instance.getAuthenticated());
        this.withError(instance.getError());
        this.withUser(instance.getUser());
    }

    @Override
    public Boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public A withAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
        return (A)this;
    }

    @Override
    public Boolean hasAuthenticated() {
        return this.authenticated != null;
    }

    @Override
    public String getError() {
        return this.error;
    }

    @Override
    public A withError(String error) {
        this.error = error;
        return (A)this;
    }

    @Override
    public Boolean hasError() {
        return this.error != null;
    }

    @Override
    @Deprecated
    public UserInfo getUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public UserInfo buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public A withUser(UserInfo user) {
        this._visitables.remove(this.user);
        if (user != null) {
            this.user = new UserInfoBuilder(user);
            this._visitables.add(this.user);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    public TokenReviewStatusFluent.UserNested<A> withNewUser() {
        return new UserNestedImpl();
    }

    @Override
    public TokenReviewStatusFluent.UserNested<A> withNewUserLike(UserInfo item) {
        return new UserNestedImpl(item);
    }

    @Override
    public TokenReviewStatusFluent.UserNested<A> editUser() {
        return this.withNewUserLike(this.getUser());
    }

    @Override
    public TokenReviewStatusFluent.UserNested<A> editOrNewUser() {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : new UserInfoBuilder().build());
    }

    @Override
    public TokenReviewStatusFluent.UserNested<A> editOrNewUserLike(UserInfo item) {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenReviewStatusFluentImpl that = (TokenReviewStatusFluentImpl)o;
        if (this.authenticated != null ? !this.authenticated.equals(that.authenticated) : that.authenticated != null) {
            return false;
        }
        if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public class UserNestedImpl<N>
    extends UserInfoFluentImpl<TokenReviewStatusFluent.UserNested<N>>
    implements TokenReviewStatusFluent.UserNested<N>,
    Nested<N> {
        private final UserInfoBuilder builder;

        UserNestedImpl(UserInfo item) {
            this.builder = new UserInfoBuilder(this, item);
        }

        UserNestedImpl() {
            this.builder = new UserInfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)TokenReviewStatusFluentImpl.this.withUser(this.builder.build());
        }

        @Override
        public N endUser() {
            return this.and();
        }
    }
}

