/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_0;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_0.SecretList;
import io.fabric8.kubernetes.api.model.v4_0.SecretListFluent;
import io.fabric8.kubernetes.api.model.v4_0.SecretListFluentImpl;

public class SecretListBuilder
extends SecretListFluentImpl<SecretListBuilder>
implements VisitableBuilder<SecretList, SecretListBuilder> {
    SecretListFluent<?> fluent;
    Boolean validationEnabled;

    public SecretListBuilder() {
        this(true);
    }

    public SecretListBuilder(Boolean validationEnabled) {
        this(new SecretList(), validationEnabled);
    }

    public SecretListBuilder(SecretListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SecretListBuilder(SecretListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SecretList(), validationEnabled);
    }

    public SecretListBuilder(SecretListFluent<?> fluent, SecretList instance) {
        this(fluent, instance, true);
    }

    public SecretListBuilder(SecretListFluent<?> fluent, SecretList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public SecretListBuilder(SecretList instance) {
        this(instance, (Boolean)true);
    }

    public SecretListBuilder(SecretList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public SecretList build() {
        SecretList buildable = new SecretList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretListBuilder that = (SecretListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

