/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_0;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_0.NodeCondition;
import io.fabric8.kubernetes.api.model.v4_0.NodeConditionFluent;
import io.fabric8.kubernetes.api.model.v4_0.NodeConditionFluentImpl;

public class NodeConditionBuilder
extends NodeConditionFluentImpl<NodeConditionBuilder>
implements VisitableBuilder<NodeCondition, NodeConditionBuilder> {
    NodeConditionFluent<?> fluent;
    Boolean validationEnabled;

    public NodeConditionBuilder() {
        this(true);
    }

    public NodeConditionBuilder(Boolean validationEnabled) {
        this(new NodeCondition(), validationEnabled);
    }

    public NodeConditionBuilder(NodeConditionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NodeConditionBuilder(NodeConditionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeCondition(), validationEnabled);
    }

    public NodeConditionBuilder(NodeConditionFluent<?> fluent, NodeCondition instance) {
        this(fluent, instance, true);
    }

    public NodeConditionBuilder(NodeConditionFluent<?> fluent, NodeCondition instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLastHeartbeatTime(instance.getLastHeartbeatTime());
        fluent.withLastTransitionTime(instance.getLastTransitionTime());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        fluent.withStatus(instance.getStatus());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public NodeConditionBuilder(NodeCondition instance) {
        this(instance, (Boolean)true);
    }

    public NodeConditionBuilder(NodeCondition instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLastHeartbeatTime(instance.getLastHeartbeatTime());
        this.withLastTransitionTime(instance.getLastTransitionTime());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NodeCondition build() {
        NodeCondition buildable = new NodeCondition(this.fluent.getLastHeartbeatTime(), this.fluent.getLastTransitionTime(), this.fluent.getMessage(), this.fluent.getReason(), this.fluent.getStatus(), this.fluent.getType());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeConditionBuilder that = (NodeConditionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

