/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_0;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import io.fabric8.kubernetes.api.model.v4_0.LimitRangeItem;
import io.fabric8.kubernetes.api.model.v4_0.LimitRangeItemBuilder;
import io.fabric8.kubernetes.api.model.v4_0.LimitRangeItemFluentImpl;
import io.fabric8.kubernetes.api.model.v4_0.LimitRangeSpec;
import io.fabric8.kubernetes.api.model.v4_0.LimitRangeSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LimitRangeSpecFluentImpl<A extends LimitRangeSpecFluent<A>>
extends BaseFluent<A>
implements LimitRangeSpecFluent<A> {
    private List<LimitRangeItemBuilder> limits = new ArrayList<LimitRangeItemBuilder>();

    public LimitRangeSpecFluentImpl() {
    }

    public LimitRangeSpecFluentImpl(LimitRangeSpec instance) {
        this.withLimits(instance.getLimits());
    }

    @Override
    public A addToLimits(int index, LimitRangeItem item) {
        if (this.limits == null) {
            this.limits = new ArrayList<LimitRangeItemBuilder>();
        }
        LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.limits.add(index >= 0 ? index : this.limits.size(), builder);
        return (A)this;
    }

    @Override
    public A setToLimits(int index, LimitRangeItem item) {
        if (this.limits == null) {
            this.limits = new ArrayList<LimitRangeItemBuilder>();
        }
        LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.limits.size()) {
            this.limits.add(builder);
        } else {
            this.limits.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToLimits(LimitRangeItem ... items) {
        if (this.limits == null) {
            this.limits = new ArrayList<LimitRangeItemBuilder>();
        }
        for (LimitRangeItem item : items) {
            LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
            this._visitables.add(builder);
            this.limits.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToLimits(Collection<LimitRangeItem> items) {
        if (this.limits == null) {
            this.limits = new ArrayList<LimitRangeItemBuilder>();
        }
        for (LimitRangeItem item : items) {
            LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
            this._visitables.add(builder);
            this.limits.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromLimits(LimitRangeItem ... items) {
        for (LimitRangeItem item : items) {
            LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
            this._visitables.remove(builder);
            if (this.limits == null) continue;
            this.limits.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLimits(Collection<LimitRangeItem> items) {
        for (LimitRangeItem item : items) {
            LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
            this._visitables.remove(builder);
            if (this.limits == null) continue;
            this.limits.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<LimitRangeItem> getLimits() {
        return LimitRangeSpecFluentImpl.build(this.limits);
    }

    @Override
    public List<LimitRangeItem> buildLimits() {
        return LimitRangeSpecFluentImpl.build(this.limits);
    }

    @Override
    public LimitRangeItem buildLimit(int index) {
        return this.limits.get(index).build();
    }

    @Override
    public LimitRangeItem buildFirstLimit() {
        return this.limits.get(0).build();
    }

    @Override
    public LimitRangeItem buildLastLimit() {
        return this.limits.get(this.limits.size() - 1).build();
    }

    @Override
    public LimitRangeItem buildMatchingLimit(Predicate<LimitRangeItemBuilder> predicate) {
        for (LimitRangeItemBuilder item : this.limits) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withLimits(List<LimitRangeItem> limits) {
        if (this.limits == null) {
            this.limits = new ArrayList<LimitRangeItemBuilder>();
        } else {
            this._visitables.removeAll(this.limits);
            this.limits.clear();
        }
        if (limits != null) {
            for (LimitRangeItem item : limits) {
                this.addToLimits(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withLimits(LimitRangeItem ... limits) {
        this.limits.clear();
        if (limits != null) {
            for (LimitRangeItem item : limits) {
                this.addToLimits(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLimits() {
        return this.limits != null && !this.limits.isEmpty();
    }

    @Override
    public LimitRangeSpecFluent.LimitsNested<A> addNewLimit() {
        return new LimitsNestedImpl();
    }

    @Override
    public LimitRangeSpecFluent.LimitsNested<A> addNewLimitLike(LimitRangeItem item) {
        return new LimitsNestedImpl(-1, item);
    }

    @Override
    public LimitRangeSpecFluent.LimitsNested<A> setNewLimitLike(int index, LimitRangeItem item) {
        return new LimitsNestedImpl(index, item);
    }

    @Override
    public LimitRangeSpecFluent.LimitsNested<A> editLimit(int index) {
        if (this.limits.size() <= index) {
            throw new RuntimeException("Can't edit limits. Index exceeds size.");
        }
        return this.setNewLimitLike(index, this.buildLimit(index));
    }

    @Override
    public LimitRangeSpecFluent.LimitsNested<A> editFirstLimit() {
        if (this.limits.size() == 0) {
            throw new RuntimeException("Can't edit first limits. The list is empty.");
        }
        return this.setNewLimitLike(0, this.buildLimit(0));
    }

    @Override
    public LimitRangeSpecFluent.LimitsNested<A> editLastLimit() {
        int index = this.limits.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last limits. The list is empty.");
        }
        return this.setNewLimitLike(index, this.buildLimit(index));
    }

    @Override
    public LimitRangeSpecFluent.LimitsNested<A> editMatchingLimit(Predicate<LimitRangeItemBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.limits.size(); ++i) {
            if (!predicate.apply(this.limits.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching limits. No match found.");
        }
        return this.setNewLimitLike(index, this.buildLimit(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LimitRangeSpecFluentImpl that = (LimitRangeSpecFluentImpl)o;
        return !(this.limits != null ? !this.limits.equals(that.limits) : that.limits != null);
    }

    public class LimitsNestedImpl<N>
    extends LimitRangeItemFluentImpl<LimitRangeSpecFluent.LimitsNested<N>>
    implements LimitRangeSpecFluent.LimitsNested<N>,
    Nested<N> {
        private final LimitRangeItemBuilder builder;
        private final int index;

        LimitsNestedImpl(int index, LimitRangeItem item) {
            this.index = index;
            this.builder = new LimitRangeItemBuilder(this, item);
        }

        LimitsNestedImpl() {
            this.index = -1;
            this.builder = new LimitRangeItemBuilder(this);
        }

        @Override
        public N and() {
            return (N)LimitRangeSpecFluentImpl.this.setToLimits(this.index, this.builder.build());
        }

        @Override
        public N endLimit() {
            return this.and();
        }
    }
}

