/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.PodSecurityPolicySpec;
import io.fabric8.kubernetes.api.model.extensions.PodSecurityPolicySpecFluent;
import io.fabric8.kubernetes.api.model.extensions.PodSecurityPolicySpecFluentImpl;

public class PodSecurityPolicySpecBuilder
extends PodSecurityPolicySpecFluentImpl<PodSecurityPolicySpecBuilder>
implements VisitableBuilder<PodSecurityPolicySpec, PodSecurityPolicySpecBuilder> {
    PodSecurityPolicySpecFluent<?> fluent;
    Boolean validationEnabled;

    public PodSecurityPolicySpecBuilder() {
        this(true);
    }

    public PodSecurityPolicySpecBuilder(Boolean validationEnabled) {
        this(new PodSecurityPolicySpec(), validationEnabled);
    }

    public PodSecurityPolicySpecBuilder(PodSecurityPolicySpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodSecurityPolicySpecBuilder(PodSecurityPolicySpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodSecurityPolicySpec(), validationEnabled);
    }

    public PodSecurityPolicySpecBuilder(PodSecurityPolicySpecFluent<?> fluent, PodSecurityPolicySpec instance) {
        this(fluent, instance, true);
    }

    public PodSecurityPolicySpecBuilder(PodSecurityPolicySpecFluent<?> fluent, PodSecurityPolicySpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAllowedCapabilities(instance.getAllowedCapabilities());
        fluent.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
        fluent.withFsGroup(instance.getFsGroup());
        fluent.withHostIPC(instance.getHostIPC());
        fluent.withHostNetwork(instance.getHostNetwork());
        fluent.withHostPID(instance.getHostPID());
        fluent.withHostPorts(instance.getHostPorts());
        fluent.withPrivileged(instance.getPrivileged());
        fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        fluent.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
        fluent.withRunAsUser(instance.getRunAsUser());
        fluent.withSeLinux(instance.getSeLinux());
        fluent.withSupplementalGroups(instance.getSupplementalGroups());
        fluent.withVolumes(instance.getVolumes());
        this.validationEnabled = validationEnabled;
    }

    public PodSecurityPolicySpecBuilder(PodSecurityPolicySpec instance) {
        this(instance, (Boolean)true);
    }

    public PodSecurityPolicySpecBuilder(PodSecurityPolicySpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAllowedCapabilities(instance.getAllowedCapabilities());
        this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
        this.withFsGroup(instance.getFsGroup());
        this.withHostIPC(instance.getHostIPC());
        this.withHostNetwork(instance.getHostNetwork());
        this.withHostPID(instance.getHostPID());
        this.withHostPorts(instance.getHostPorts());
        this.withPrivileged(instance.getPrivileged());
        this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinux(instance.getSeLinux());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.withVolumes(instance.getVolumes());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public PodSecurityPolicySpec build() {
        PodSecurityPolicySpec buildable = new PodSecurityPolicySpec(this.fluent.getAllowedCapabilities(), this.fluent.getDefaultAddCapabilities(), this.fluent.getFsGroup(), this.fluent.isHostIPC(), this.fluent.isHostNetwork(), this.fluent.isHostPID(), this.fluent.getHostPorts(), this.fluent.isPrivileged(), this.fluent.isReadOnlyRootFilesystem(), this.fluent.getRequiredDropCapabilities(), this.fluent.getRunAsUser(), this.fluent.getSeLinux(), this.fluent.getSupplementalGroups(), this.fluent.getVolumes());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSecurityPolicySpecBuilder that = (PodSecurityPolicySpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

