/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_1.extensions;

import io.fabric8.kubernetes.api.builder.v3_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v3_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v3_1.extensions.Deployment;
import io.fabric8.kubernetes.api.model.v3_1.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.v3_1.extensions.DeploymentFluentImpl;

public class DeploymentBuilder
extends DeploymentFluentImpl<DeploymentBuilder>
implements VisitableBuilder<Deployment, DeploymentBuilder> {
    DeploymentFluent<?> fluent;
    Boolean validationEnabled;

    public DeploymentBuilder() {
        this(true);
    }

    public DeploymentBuilder(Boolean validationEnabled) {
        this(new Deployment(), validationEnabled);
    }

    public DeploymentBuilder(DeploymentFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DeploymentBuilder(DeploymentFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Deployment(), validationEnabled);
    }

    public DeploymentBuilder(DeploymentFluent<?> fluent, Deployment instance) {
        this(fluent, instance, true);
    }

    public DeploymentBuilder(DeploymentFluent<?> fluent, Deployment instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentBuilder(Deployment instance) {
        this(instance, (Boolean)true);
    }

    public DeploymentBuilder(Deployment instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Deployment build() {
        Deployment buildable = new Deployment(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentBuilder that = (DeploymentBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

