/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_1.authentication;

import io.fabric8.kubernetes.api.builder.v3_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_1.Predicate;
import io.fabric8.kubernetes.api.model.v3_1.authentication.UserInfo;
import io.fabric8.kubernetes.api.model.v3_1.authentication.UserInfoFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UserInfoFluentImpl<A extends UserInfoFluent<A>>
extends BaseFluent<A>
implements UserInfoFluent<A> {
    private Map<String, ArrayList<String>> extra = new LinkedHashMap<String, ArrayList<String>>();
    private List<String> groups = new ArrayList<String>();
    private String uid;
    private String username;

    public UserInfoFluentImpl() {
    }

    public UserInfoFluentImpl(UserInfo instance) {
        this.withExtra(instance.getExtra());
        this.withGroups(instance.getGroups());
        this.withUid(instance.getUid());
        this.withUsername(instance.getUsername());
    }

    @Override
    public A addToExtra(String key, ArrayList<String> value) {
        if (key != null && value != null) {
            this.extra.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToExtra(Map<String, ArrayList<String>> map) {
        if (map != null) {
            this.extra.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(String key) {
        if (key != null) {
            this.extra.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(Map<String, ArrayList<String>> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.extra.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, ArrayList<String>> getExtra() {
        return this.extra;
    }

    @Override
    public A withExtra(Map<String, ArrayList<String>> extra) {
        this.extra.clear();
        if (extra != null) {
            this.extra.putAll(extra);
        }
        return (A)this;
    }

    @Override
    public Boolean hasExtra() {
        return this.extra != null;
    }

    @Override
    public A addToGroups(int index, String item) {
        this.groups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroups(int index, String item) {
        this.groups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroups(String ... items) {
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroups(Collection<String> items) {
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(String ... items) {
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroups(Collection<String> items) {
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public String getGroup(int index) {
        return this.groups.get(index);
    }

    @Override
    public String getFirstGroup() {
        return this.groups.get(0);
    }

    @Override
    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    @Override
    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withGroups(List<String> groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withGroups(String ... groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    @Override
    public Boolean hasUid() {
        return this.uid != null;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    @Override
    public Boolean hasUsername() {
        return this.username != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserInfoFluentImpl that = (UserInfoFluentImpl)o;
        if (this.extra != null ? !this.extra.equals(that.extra) : that.extra != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.uid != null ? !this.uid.equals(that.uid) : that.uid != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }
}

