/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_1;

import io.fabric8.kubernetes.api.builder.v3_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v3_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v3_1.Container;
import io.fabric8.kubernetes.api.model.v3_1.ContainerFluent;
import io.fabric8.kubernetes.api.model.v3_1.ContainerFluentImpl;

public class ContainerBuilder
extends ContainerFluentImpl<ContainerBuilder>
implements VisitableBuilder<Container, ContainerBuilder> {
    ContainerFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerBuilder() {
        this(true);
    }

    public ContainerBuilder(Boolean validationEnabled) {
        this(new Container(), validationEnabled);
    }

    public ContainerBuilder(ContainerFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContainerBuilder(ContainerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Container(), validationEnabled);
    }

    public ContainerBuilder(ContainerFluent<?> fluent, Container instance) {
        this(fluent, instance, true);
    }

    public ContainerBuilder(ContainerFluent<?> fluent, Container instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withArgs(instance.getArgs());
        fluent.withCommand(instance.getCommand());
        fluent.withEnv(instance.getEnv());
        fluent.withEnvFrom(instance.getEnvFrom());
        fluent.withImage(instance.getImage());
        fluent.withImagePullPolicy(instance.getImagePullPolicy());
        fluent.withLifecycle(instance.getLifecycle());
        fluent.withLivenessProbe(instance.getLivenessProbe());
        fluent.withName(instance.getName());
        fluent.withPorts(instance.getPorts());
        fluent.withReadinessProbe(instance.getReadinessProbe());
        fluent.withResources(instance.getResources());
        fluent.withSecurityContext(instance.getSecurityContext());
        fluent.withStdin(instance.getStdin());
        fluent.withStdinOnce(instance.getStdinOnce());
        fluent.withTerminationMessagePath(instance.getTerminationMessagePath());
        fluent.withTerminationMessagePolicy(instance.getTerminationMessagePolicy());
        fluent.withTty(instance.getTty());
        fluent.withVolumeMounts(instance.getVolumeMounts());
        fluent.withWorkingDir(instance.getWorkingDir());
        this.validationEnabled = validationEnabled;
    }

    public ContainerBuilder(Container instance) {
        this(instance, (Boolean)true);
    }

    public ContainerBuilder(Container instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withArgs(instance.getArgs());
        this.withCommand(instance.getCommand());
        this.withEnv(instance.getEnv());
        this.withEnvFrom(instance.getEnvFrom());
        this.withImage(instance.getImage());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withLifecycle(instance.getLifecycle());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withName(instance.getName());
        this.withPorts(instance.getPorts());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withResources(instance.getResources());
        this.withSecurityContext(instance.getSecurityContext());
        this.withStdin(instance.getStdin());
        this.withStdinOnce(instance.getStdinOnce());
        this.withTerminationMessagePath(instance.getTerminationMessagePath());
        this.withTerminationMessagePolicy(instance.getTerminationMessagePolicy());
        this.withTty(instance.getTty());
        this.withVolumeMounts(instance.getVolumeMounts());
        this.withWorkingDir(instance.getWorkingDir());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Container build() {
        Container buildable = new Container(this.fluent.getArgs(), this.fluent.getCommand(), this.fluent.getEnv(), this.fluent.getEnvFrom(), this.fluent.getImage(), this.fluent.getImagePullPolicy(), this.fluent.getLifecycle(), this.fluent.getLivenessProbe(), this.fluent.getName(), this.fluent.getPorts(), this.fluent.getReadinessProbe(), this.fluent.getResources(), this.fluent.getSecurityContext(), this.fluent.isStdin(), this.fluent.isStdinOnce(), this.fluent.getTerminationMessagePath(), this.fluent.getTerminationMessagePolicy(), this.fluent.isTty(), this.fluent.getVolumeMounts(), this.fluent.getWorkingDir());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerBuilder that = (ContainerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

