/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_1;

import io.fabric8.kubernetes.api.builder.v3_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_1.Nested;
import io.fabric8.kubernetes.api.model.v3_1.ConfigMap;
import io.fabric8.kubernetes.api.model.v3_1.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.v3_1.ObjectMeta;
import io.fabric8.kubernetes.api.model.v3_1.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v3_1.ObjectMetaFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConfigMapFluentImpl<A extends ConfigMapFluent<A>>
extends BaseFluent<A>
implements ConfigMapFluent<A> {
    private String apiVersion;
    private Map<String, String> data = new LinkedHashMap<String, String>();
    private String kind;
    private ObjectMetaBuilder metadata;

    public ConfigMapFluentImpl() {
    }

    public ConfigMapFluentImpl(ConfigMap instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withData(instance.getData());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToData(String key, String value) {
        if (key != null && value != null) {
            this.data.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToData(Map<String, String> map) {
        if (map != null) {
            this.data.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromData(String key) {
        if (key != null) {
            this.data.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromData(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.data.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getData() {
        return this.data;
    }

    @Override
    public A withData(Map<String, String> data) {
        this.data.clear();
        if (data != null) {
            this.data.putAll(data);
        }
        return (A)this;
    }

    @Override
    public Boolean hasData() {
        return this.data != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ConfigMapFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ConfigMapFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ConfigMapFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ConfigMapFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ConfigMapFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigMapFluentImpl that = (ConfigMapFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ConfigMapFluent.MetadataNested<N>>
    implements ConfigMapFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConfigMapFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

