/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ConfigMapProjection;
import io.fabric8.kubernetes.api.model.ConfigMapProjectionFluent;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.KeyToPathBuilder;
import io.fabric8.kubernetes.api.model.KeyToPathFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConfigMapProjectionFluentImpl<A extends ConfigMapProjectionFluent<A>>
extends BaseFluent<A>
implements ConfigMapProjectionFluent<A> {
    private List<KeyToPathBuilder> items = new ArrayList<KeyToPathBuilder>();
    private String name;
    private Boolean optional;

    public ConfigMapProjectionFluentImpl() {
    }

    public ConfigMapProjectionFluentImpl(ConfigMapProjection instance) {
        this.withItems(instance.getItems());
        this.withName(instance.getName());
        this.withOptional(instance.getOptional());
    }

    @Override
    public A addToItems(int index, KeyToPath item) {
        KeyToPathBuilder builder = new KeyToPathBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, KeyToPath item) {
        KeyToPathBuilder builder = new KeyToPathBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(KeyToPath ... items) {
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<KeyToPath> items) {
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(KeyToPath ... items) {
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<KeyToPath> items) {
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<KeyToPath> getItems() {
        return ConfigMapProjectionFluentImpl.build(this.items);
    }

    @Override
    public List<KeyToPath> buildItems() {
        return ConfigMapProjectionFluentImpl.build(this.items);
    }

    @Override
    public KeyToPath buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public KeyToPath buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public KeyToPath buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public KeyToPath buildMatchingItem(Predicate<KeyToPathBuilder> predicate) {
        for (KeyToPathBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withItems(List<KeyToPath> items) {
        this._visitables.removeAll(this.items);
        this.items.clear();
        if (items != null) {
            for (KeyToPath item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withItems(KeyToPath ... items) {
        this.items.clear();
        if (items != null) {
            for (KeyToPath item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ConfigMapProjectionFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ConfigMapProjectionFluent.ItemsNested<A> addNewItemLike(KeyToPath item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ConfigMapProjectionFluent.ItemsNested<A> setNewItemLike(int index, KeyToPath item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ConfigMapProjectionFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ConfigMapProjectionFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ConfigMapProjectionFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ConfigMapProjectionFluent.ItemsNested<A> editMatchingItem(Predicate<KeyToPathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply(this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public A addNewItem(String key, Integer mode, String path) {
        return this.addToItems(new KeyToPath(key, mode, path));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public Boolean isOptional() {
        return this.optional;
    }

    @Override
    public A withOptional(Boolean optional) {
        this.optional = optional;
        return (A)this;
    }

    @Override
    public Boolean hasOptional() {
        return this.optional != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigMapProjectionFluentImpl that = (ConfigMapProjectionFluentImpl)o;
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.optional != null ? !this.optional.equals(that.optional) : that.optional != null);
    }

    public class ItemsNestedImpl<N>
    extends KeyToPathFluentImpl<ConfigMapProjectionFluent.ItemsNested<N>>
    implements ConfigMapProjectionFluent.ItemsNested<N>,
    Nested<N> {
        private final KeyToPathBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, KeyToPath item) {
            this.index = index;
            this.builder = new KeyToPathBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new KeyToPathBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConfigMapProjectionFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

