/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import io.fabric8.kubernetes.api.builder.Function;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import io.fabric8.kubernetes.client.internal.readiness.ReadinessWatcher;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class HasMetadataOperation<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends Resource<T, D>>
extends BaseOperation<T, L, D, R> {
    protected HasMetadataOperation(OkHttpClient client, Config config, String apiGroup, String apiVersion, String resourceT, String namespace, String name, Boolean cascading, T item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config, apiGroup, apiVersion, resourceT, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
    }

    public HasMetadataOperation(OkHttpClient client, Config config, String apiGroup, String apiVersion, String resourceT, String namespace, String name, Boolean cascading, T item, String resourceVersion, Boolean reloadingFromServer, Class<T> type, Class<L> listType, Class<D> doneableType) {
        super(client, config, apiGroup, apiVersion, resourceT, namespace, name, cascading, item, resourceVersion, reloadingFromServer, type, listType, doneableType);
    }

    @Override
    public D edit() throws KubernetesClientException {
        Function visitor = new Function<T, T>(){

            @Override
            public T apply(T resource) {
                try {
                    if (HasMetadataOperation.this.isCascading().booleanValue() && !HasMetadataOperation.this.isReaping() && HasMetadataOperation.this.reaper != null) {
                        HasMetadataOperation.this.setReaping(true);
                        HasMetadataOperation.this.reaper.reap();
                    }
                    return HasMetadataOperation.this.patch(resource);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(HasMetadataOperation.this.forOperationType("edit"), (Throwable)e);
                }
            }
        };
        try {
            HasMetadata item = (HasMetadata)this.getMandatory();
            return (D)((Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Function.class).newInstance(item, visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("edit"), (Throwable)e);
        }
    }

    @Override
    public T replace(T item) {
        String fixedResourceVersion = this.getResourceVersion();
        Exception caught = null;
        int maxTries = 10;
        for (int i = 0; i < maxTries; ++i) {
            try {
                String resourceVersion;
                if (this.isCascading().booleanValue() && this.reaper != null && !this.isReaping()) {
                    this.setReaping(true);
                    this.reaper.reap();
                }
                if (fixedResourceVersion != null) {
                    resourceVersion = fixedResourceVersion;
                } else {
                    HasMetadata got = (HasMetadata)this.get();
                    if (got == null) {
                        return null;
                    }
                    resourceVersion = got.getMetadata() != null ? got.getMetadata().getResourceVersion() : null;
                }
                Function visitor = new Function<T, T>(){

                    @Override
                    public T apply(T resource) {
                        try {
                            resource.getMetadata().setResourceVersion(resourceVersion);
                            return (HasMetadata)HasMetadataOperation.this.handleReplace(resource);
                        }
                        catch (Exception e) {
                            throw KubernetesClientException.launderThrowable(HasMetadataOperation.this.forOperationType("replace"), (Throwable)e);
                        }
                    }
                };
                Doneable doneable = (Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Function.class).newInstance(item, visitor);
                return (T)((HasMetadata)doneable.done());
            }
            catch (KubernetesClientException e) {
                caught = e;
                if (e.getCode() != 409 || fixedResourceVersion != null) break;
                if (i >= maxTries - 1) continue;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (Exception e) {
                caught = e;
            }
        }
        throw KubernetesClientException.launderThrowable(this.forOperationType("replace"), (Throwable)caught);
    }

    @Override
    public T patch(T item) {
        Exception caught = null;
        int maxTries = 10;
        for (int i = 0; i < maxTries; ++i) {
            try {
                HasMetadata got;
                if (this.isCascading().booleanValue() && this.reaper != null && !this.isReaping()) {
                    this.setReaping(true);
                    this.reaper.reap();
                }
                if ((got = (HasMetadata)this.get()) == null) {
                    return null;
                }
                Function visitor = new Function<T, T>(){

                    @Override
                    public T apply(T resource) {
                        try {
                            return HasMetadataOperation.this.handlePatch(got, resource);
                        }
                        catch (Exception e) {
                            throw KubernetesClientException.launderThrowable(HasMetadataOperation.this.forOperationType("patch"), (Throwable)e);
                        }
                    }
                };
                Doneable doneable = (Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Function.class).newInstance(item, visitor);
                return (T)((HasMetadata)doneable.done());
            }
            catch (KubernetesClientException e) {
                caught = e;
                if (e.getCode() != 409) break;
                if (i >= maxTries - 1) continue;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (Exception e) {
                caught = e;
            }
        }
        throw KubernetesClientException.launderThrowable(this.forOperationType("patch"), (Throwable)caught);
    }

    protected T periodicWatchUntilReady(int i, long started, long interval, long amount) {
        HasMetadata item = (HasMetadata)this.fromServer().get();
        if (Readiness.isReady(item)) {
            return (T)item;
        }
        ReadinessWatcher<HasMetadata> watcher = new ReadinessWatcher<HasMetadata>(item);
        Throwable throwable = null;
        try (Watch watch = this.watch(watcher);){
            HasMetadata hasMetadata = watcher.await(interval, TimeUnit.MILLISECONDS);
            return (T)hasMetadata;
        }
        catch (KubernetesClientTimeoutException e) {
            if (i <= 0) {
                throw e;
            }
            long remaining = started + amount - System.currentTimeMillis();
            long next = Math.max(0L, Math.min(remaining, interval));
            T t = this.periodicWatchUntilReady(i - 1, started, next, amount);
            return t;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }
}

