/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.Time;
import io.fabric8.kubernetes.api.model.TimeBuilder;
import io.fabric8.kubernetes.api.model.TimeFluentImpl;
import io.fabric8.openshift.api.model.ImageSignature;
import io.fabric8.openshift.api.model.ImageSignatureFluent;
import io.fabric8.openshift.api.model.SignatureCondition;
import io.fabric8.openshift.api.model.SignatureConditionBuilder;
import io.fabric8.openshift.api.model.SignatureConditionFluentImpl;
import io.fabric8.openshift.api.model.SignatureIssuer;
import io.fabric8.openshift.api.model.SignatureIssuerBuilder;
import io.fabric8.openshift.api.model.SignatureIssuerFluentImpl;
import io.fabric8.openshift.api.model.SignatureSubject;
import io.fabric8.openshift.api.model.SignatureSubjectBuilder;
import io.fabric8.openshift.api.model.SignatureSubjectFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ImageSignatureFluentImpl<A extends ImageSignatureFluent<A>>
extends BaseFluent<A>
implements ImageSignatureFluent<A> {
    private String apiVersion;
    private List<SignatureConditionBuilder> conditions = new ArrayList<SignatureConditionBuilder>();
    private String content;
    private TimeBuilder created;
    private String imageIdentity;
    private SignatureIssuerBuilder issuedBy;
    private SignatureSubjectBuilder issuedTo;
    private String kind;
    private ObjectMetaBuilder metadata;
    private Map<String, String> signedClaims = new LinkedHashMap<String, String>();
    private String type;

    public ImageSignatureFluentImpl() {
    }

    public ImageSignatureFluentImpl(ImageSignature instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withConditions(instance.getConditions());
        this.withContent(instance.getContent());
        this.withCreated(instance.getCreated());
        this.withImageIdentity(instance.getImageIdentity());
        this.withIssuedBy(instance.getIssuedBy());
        this.withIssuedTo(instance.getIssuedTo());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSignedClaims(instance.getSignedClaims());
        this.withType(instance.getType());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToConditions(int index, SignatureCondition item) {
        SignatureConditionBuilder builder = new SignatureConditionBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, SignatureCondition item) {
        SignatureConditionBuilder builder = new SignatureConditionBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(SignatureCondition ... items) {
        for (SignatureCondition item : items) {
            SignatureConditionBuilder builder = new SignatureConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<SignatureCondition> items) {
        for (SignatureCondition item : items) {
            SignatureConditionBuilder builder = new SignatureConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(SignatureCondition ... items) {
        for (SignatureCondition item : items) {
            SignatureConditionBuilder builder = new SignatureConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<SignatureCondition> items) {
        for (SignatureCondition item : items) {
            SignatureConditionBuilder builder = new SignatureConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SignatureCondition> getConditions() {
        return ImageSignatureFluentImpl.build(this.conditions);
    }

    @Override
    public List<SignatureCondition> buildConditions() {
        return ImageSignatureFluentImpl.build(this.conditions);
    }

    @Override
    public SignatureCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public SignatureCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public SignatureCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public SignatureCondition buildMatchingCondition(Predicate<SignatureConditionBuilder> predicate) {
        for (SignatureConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withConditions(List<SignatureCondition> conditions) {
        this._visitables.removeAll(this.conditions);
        this.conditions.clear();
        if (conditions != null) {
            for (SignatureCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withConditions(SignatureCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (SignatureCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public ImageSignatureFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public ImageSignatureFluent.ConditionsNested<A> addNewConditionLike(SignatureCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public ImageSignatureFluent.ConditionsNested<A> setNewConditionLike(int index, SignatureCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public ImageSignatureFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ImageSignatureFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public ImageSignatureFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ImageSignatureFluent.ConditionsNested<A> editMatchingCondition(Predicate<SignatureConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public A withContent(String content) {
        this.content = content;
        return (A)this;
    }

    @Override
    public Boolean hasContent() {
        return this.content != null;
    }

    @Override
    @Deprecated
    public Time getCreated() {
        return this.created != null ? this.created.build() : null;
    }

    @Override
    public Time buildCreated() {
        return this.created != null ? this.created.build() : null;
    }

    @Override
    public A withCreated(Time created) {
        this._visitables.remove(this.created);
        if (created != null) {
            this.created = new TimeBuilder(created);
            this._visitables.add(this.created);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCreated() {
        return this.created != null;
    }

    @Override
    public ImageSignatureFluent.CreatedNested<A> withNewCreated() {
        return new CreatedNestedImpl();
    }

    @Override
    public ImageSignatureFluent.CreatedNested<A> withNewCreatedLike(Time item) {
        return new CreatedNestedImpl(item);
    }

    @Override
    public ImageSignatureFluent.CreatedNested<A> editCreated() {
        return this.withNewCreatedLike(this.getCreated());
    }

    @Override
    public ImageSignatureFluent.CreatedNested<A> editOrNewCreated() {
        return this.withNewCreatedLike(this.getCreated() != null ? this.getCreated() : new TimeBuilder().build());
    }

    @Override
    public ImageSignatureFluent.CreatedNested<A> editOrNewCreatedLike(Time item) {
        return this.withNewCreatedLike(this.getCreated() != null ? this.getCreated() : item);
    }

    @Override
    public A withNewCreated(String time) {
        return this.withCreated(new Time(time));
    }

    @Override
    public String getImageIdentity() {
        return this.imageIdentity;
    }

    @Override
    public A withImageIdentity(String imageIdentity) {
        this.imageIdentity = imageIdentity;
        return (A)this;
    }

    @Override
    public Boolean hasImageIdentity() {
        return this.imageIdentity != null;
    }

    @Override
    @Deprecated
    public SignatureIssuer getIssuedBy() {
        return this.issuedBy != null ? this.issuedBy.build() : null;
    }

    @Override
    public SignatureIssuer buildIssuedBy() {
        return this.issuedBy != null ? this.issuedBy.build() : null;
    }

    @Override
    public A withIssuedBy(SignatureIssuer issuedBy) {
        this._visitables.remove(this.issuedBy);
        if (issuedBy != null) {
            this.issuedBy = new SignatureIssuerBuilder(issuedBy);
            this._visitables.add(this.issuedBy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIssuedBy() {
        return this.issuedBy != null;
    }

    @Override
    public ImageSignatureFluent.IssuedByNested<A> withNewIssuedBy() {
        return new IssuedByNestedImpl();
    }

    @Override
    public ImageSignatureFluent.IssuedByNested<A> withNewIssuedByLike(SignatureIssuer item) {
        return new IssuedByNestedImpl(item);
    }

    @Override
    public ImageSignatureFluent.IssuedByNested<A> editIssuedBy() {
        return this.withNewIssuedByLike(this.getIssuedBy());
    }

    @Override
    public ImageSignatureFluent.IssuedByNested<A> editOrNewIssuedBy() {
        return this.withNewIssuedByLike(this.getIssuedBy() != null ? this.getIssuedBy() : new SignatureIssuerBuilder().build());
    }

    @Override
    public ImageSignatureFluent.IssuedByNested<A> editOrNewIssuedByLike(SignatureIssuer item) {
        return this.withNewIssuedByLike(this.getIssuedBy() != null ? this.getIssuedBy() : item);
    }

    @Override
    public A withNewIssuedBy(String commonName, String organization) {
        return this.withIssuedBy(new SignatureIssuer(commonName, organization));
    }

    @Override
    @Deprecated
    public SignatureSubject getIssuedTo() {
        return this.issuedTo != null ? this.issuedTo.build() : null;
    }

    @Override
    public SignatureSubject buildIssuedTo() {
        return this.issuedTo != null ? this.issuedTo.build() : null;
    }

    @Override
    public A withIssuedTo(SignatureSubject issuedTo) {
        this._visitables.remove(this.issuedTo);
        if (issuedTo != null) {
            this.issuedTo = new SignatureSubjectBuilder(issuedTo);
            this._visitables.add(this.issuedTo);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIssuedTo() {
        return this.issuedTo != null;
    }

    @Override
    public ImageSignatureFluent.IssuedToNested<A> withNewIssuedTo() {
        return new IssuedToNestedImpl();
    }

    @Override
    public ImageSignatureFluent.IssuedToNested<A> withNewIssuedToLike(SignatureSubject item) {
        return new IssuedToNestedImpl(item);
    }

    @Override
    public ImageSignatureFluent.IssuedToNested<A> editIssuedTo() {
        return this.withNewIssuedToLike(this.getIssuedTo());
    }

    @Override
    public ImageSignatureFluent.IssuedToNested<A> editOrNewIssuedTo() {
        return this.withNewIssuedToLike(this.getIssuedTo() != null ? this.getIssuedTo() : new SignatureSubjectBuilder().build());
    }

    @Override
    public ImageSignatureFluent.IssuedToNested<A> editOrNewIssuedToLike(SignatureSubject item) {
        return this.withNewIssuedToLike(this.getIssuedTo() != null ? this.getIssuedTo() : item);
    }

    @Override
    public A withNewIssuedTo(String commonName, String organization, String publicKeyID) {
        return this.withIssuedTo(new SignatureSubject(commonName, organization, publicKeyID));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ImageSignatureFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ImageSignatureFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ImageSignatureFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ImageSignatureFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ImageSignatureFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToSignedClaims(String key, String value) {
        if (key != null && value != null) {
            this.signedClaims.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSignedClaims(Map<String, String> map) {
        if (map != null) {
            this.signedClaims.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSignedClaims(String key) {
        if (key != null) {
            this.signedClaims.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSignedClaims(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.signedClaims.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSignedClaims() {
        return this.signedClaims;
    }

    @Override
    public A withSignedClaims(Map<String, String> signedClaims) {
        this.signedClaims.clear();
        if (signedClaims != null) {
            this.signedClaims.putAll(signedClaims);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSignedClaims() {
        return this.signedClaims != null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageSignatureFluentImpl that = (ImageSignatureFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.content != null ? !this.content.equals(that.content) : that.content != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(that.created) : that.created != null) {
            return false;
        }
        if (this.imageIdentity != null ? !this.imageIdentity.equals(that.imageIdentity) : that.imageIdentity != null) {
            return false;
        }
        if (this.issuedBy != null ? !this.issuedBy.equals(that.issuedBy) : that.issuedBy != null) {
            return false;
        }
        if (this.issuedTo != null ? !this.issuedTo.equals(that.issuedTo) : that.issuedTo != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.signedClaims != null ? !this.signedClaims.equals(that.signedClaims) : that.signedClaims != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ImageSignatureFluent.MetadataNested<N>>
    implements ImageSignatureFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageSignatureFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class IssuedToNestedImpl<N>
    extends SignatureSubjectFluentImpl<ImageSignatureFluent.IssuedToNested<N>>
    implements ImageSignatureFluent.IssuedToNested<N>,
    Nested<N> {
        private final SignatureSubjectBuilder builder;

        IssuedToNestedImpl(SignatureSubject item) {
            this.builder = new SignatureSubjectBuilder(this, item);
        }

        IssuedToNestedImpl() {
            this.builder = new SignatureSubjectBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageSignatureFluentImpl.this.withIssuedTo(this.builder.build());
        }

        @Override
        public N endIssuedTo() {
            return this.and();
        }
    }

    public class IssuedByNestedImpl<N>
    extends SignatureIssuerFluentImpl<ImageSignatureFluent.IssuedByNested<N>>
    implements ImageSignatureFluent.IssuedByNested<N>,
    Nested<N> {
        private final SignatureIssuerBuilder builder;

        IssuedByNestedImpl(SignatureIssuer item) {
            this.builder = new SignatureIssuerBuilder(this, item);
        }

        IssuedByNestedImpl() {
            this.builder = new SignatureIssuerBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageSignatureFluentImpl.this.withIssuedBy(this.builder.build());
        }

        @Override
        public N endIssuedBy() {
            return this.and();
        }
    }

    public class CreatedNestedImpl<N>
    extends TimeFluentImpl<ImageSignatureFluent.CreatedNested<N>>
    implements ImageSignatureFluent.CreatedNested<N>,
    Nested<N> {
        private final TimeBuilder builder;

        CreatedNestedImpl(Time item) {
            this.builder = new TimeBuilder(this, item);
        }

        CreatedNestedImpl() {
            this.builder = new TimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageSignatureFluentImpl.this.withCreated(this.builder.build());
        }

        @Override
        public N endCreated() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends SignatureConditionFluentImpl<ImageSignatureFluent.ConditionsNested<N>>
    implements ImageSignatureFluent.ConditionsNested<N>,
    Nested<N> {
        private final SignatureConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, SignatureCondition item) {
            this.index = index;
            this.builder = new SignatureConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new SignatureConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageSignatureFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

