/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.NodeSelectorRequirement;
import io.fabric8.kubernetes.api.model.NodeSelectorRequirementBuilder;
import io.fabric8.kubernetes.api.model.NodeSelectorRequirementFluentImpl;
import io.fabric8.kubernetes.api.model.NodeSelectorTerm;
import io.fabric8.kubernetes.api.model.NodeSelectorTermFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodeSelectorTermFluentImpl<A extends NodeSelectorTermFluent<A>>
extends BaseFluent<A>
implements NodeSelectorTermFluent<A> {
    private List<NodeSelectorRequirementBuilder> matchExpressions = new ArrayList<NodeSelectorRequirementBuilder>();

    public NodeSelectorTermFluentImpl() {
    }

    public NodeSelectorTermFluentImpl(NodeSelectorTerm instance) {
        this.withMatchExpressions(instance.getMatchExpressions());
    }

    @Override
    public A addToMatchExpressions(int index, NodeSelectorRequirement item) {
        NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.matchExpressions.add(index >= 0 ? index : this.matchExpressions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMatchExpressions(int index, NodeSelectorRequirement item) {
        NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.matchExpressions.size()) {
            this.matchExpressions.add(builder);
        } else {
            this.matchExpressions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMatchExpressions(NodeSelectorRequirement ... items) {
        for (NodeSelectorRequirement item : items) {
            NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
            this._visitables.add(builder);
            this.matchExpressions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMatchExpressions(Collection<NodeSelectorRequirement> items) {
        for (NodeSelectorRequirement item : items) {
            NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
            this._visitables.add(builder);
            this.matchExpressions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatchExpressions(NodeSelectorRequirement ... items) {
        for (NodeSelectorRequirement item : items) {
            NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
            this._visitables.remove(builder);
            this.matchExpressions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMatchExpressions(Collection<NodeSelectorRequirement> items) {
        for (NodeSelectorRequirement item : items) {
            NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
            this._visitables.remove(builder);
            this.matchExpressions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NodeSelectorRequirement> getMatchExpressions() {
        return NodeSelectorTermFluentImpl.build(this.matchExpressions);
    }

    @Override
    public List<NodeSelectorRequirement> buildMatchExpressions() {
        return NodeSelectorTermFluentImpl.build(this.matchExpressions);
    }

    @Override
    public NodeSelectorRequirement buildMatchExpression(int index) {
        return this.matchExpressions.get(index).build();
    }

    @Override
    public NodeSelectorRequirement buildFirstMatchExpression() {
        return this.matchExpressions.get(0).build();
    }

    @Override
    public NodeSelectorRequirement buildLastMatchExpression() {
        return this.matchExpressions.get(this.matchExpressions.size() - 1).build();
    }

    @Override
    public NodeSelectorRequirement buildMatchingMatchExpression(Predicate<NodeSelectorRequirementBuilder> predicate) {
        for (NodeSelectorRequirementBuilder item : this.matchExpressions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withMatchExpressions(List<NodeSelectorRequirement> matchExpressions) {
        this._visitables.removeAll(this.matchExpressions);
        this.matchExpressions.clear();
        if (matchExpressions != null) {
            for (NodeSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withMatchExpressions(NodeSelectorRequirement ... matchExpressions) {
        this.matchExpressions.clear();
        if (matchExpressions != null) {
            for (NodeSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMatchExpressions() {
        return this.matchExpressions != null && !this.matchExpressions.isEmpty();
    }

    @Override
    public NodeSelectorTermFluent.MatchExpressionsNested<A> addNewMatchExpression() {
        return new MatchExpressionsNestedImpl();
    }

    @Override
    public NodeSelectorTermFluent.MatchExpressionsNested<A> addNewMatchExpressionLike(NodeSelectorRequirement item) {
        return new MatchExpressionsNestedImpl(-1, item);
    }

    @Override
    public NodeSelectorTermFluent.MatchExpressionsNested<A> setNewMatchExpressionLike(int index, NodeSelectorRequirement item) {
        return new MatchExpressionsNestedImpl(index, item);
    }

    @Override
    public NodeSelectorTermFluent.MatchExpressionsNested<A> editMatchExpression(int index) {
        if (this.matchExpressions.size() <= index) {
            throw new RuntimeException("Can't edit matchExpressions. Index exceeds size.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    @Override
    public NodeSelectorTermFluent.MatchExpressionsNested<A> editFirstMatchExpression() {
        if (this.matchExpressions.size() == 0) {
            throw new RuntimeException("Can't edit first matchExpressions. The list is empty.");
        }
        return this.setNewMatchExpressionLike(0, this.buildMatchExpression(0));
    }

    @Override
    public NodeSelectorTermFluent.MatchExpressionsNested<A> editLastMatchExpression() {
        int index = this.matchExpressions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchExpressions. The list is empty.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    @Override
    public NodeSelectorTermFluent.MatchExpressionsNested<A> editMatchingMatchExpression(Predicate<NodeSelectorRequirementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchExpressions.size(); ++i) {
            if (!predicate.apply(this.matchExpressions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchExpressions. No match found.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSelectorTermFluentImpl that = (NodeSelectorTermFluentImpl)o;
        return !(this.matchExpressions != null ? !this.matchExpressions.equals(that.matchExpressions) : that.matchExpressions != null);
    }

    public class MatchExpressionsNestedImpl<N>
    extends NodeSelectorRequirementFluentImpl<NodeSelectorTermFluent.MatchExpressionsNested<N>>
    implements NodeSelectorTermFluent.MatchExpressionsNested<N>,
    Nested<N> {
        private final NodeSelectorRequirementBuilder builder;
        private final int index;

        MatchExpressionsNestedImpl(int index, NodeSelectorRequirement item) {
            this.index = index;
            this.builder = new NodeSelectorRequirementBuilder(this, item);
        }

        MatchExpressionsNestedImpl() {
            this.index = -1;
            this.builder = new NodeSelectorRequirementBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeSelectorTermFluentImpl.this.setToMatchExpressions(this.index, this.builder.build());
        }

        @Override
        public N endMatchExpression() {
            return this.and();
        }
    }
}

