/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Time;
import io.fabric8.kubernetes.api.model.TimeBuilder;
import io.fabric8.kubernetes.api.model.TimeFluentImpl;
import io.fabric8.openshift.api.model.StepInfo;
import io.fabric8.openshift.api.model.StepInfoFluent;

public class StepInfoFluentImpl<A extends StepInfoFluent<A>>
extends BaseFluent<A>
implements StepInfoFluent<A> {
    private Long durationMilliseconds;
    private String name;
    private TimeBuilder startTime;

    public StepInfoFluentImpl() {
    }

    public StepInfoFluentImpl(StepInfo instance) {
        this.withDurationMilliseconds(instance.getDurationMilliseconds());
        this.withName(instance.getName());
        this.withStartTime(instance.getStartTime());
    }

    @Override
    public Long getDurationMilliseconds() {
        return this.durationMilliseconds;
    }

    @Override
    public A withDurationMilliseconds(Long durationMilliseconds) {
        this.durationMilliseconds = durationMilliseconds;
        return (A)this;
    }

    @Override
    public Boolean hasDurationMilliseconds() {
        return this.durationMilliseconds != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public Time getStartTime() {
        return this.startTime != null ? this.startTime.build() : null;
    }

    @Override
    public Time buildStartTime() {
        return this.startTime != null ? this.startTime.build() : null;
    }

    @Override
    public A withStartTime(Time startTime) {
        this._visitables.remove(this.startTime);
        if (startTime != null) {
            this.startTime = new TimeBuilder(startTime);
            this._visitables.add(this.startTime);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    @Override
    public StepInfoFluent.StartTimeNested<A> withNewStartTime() {
        return new StartTimeNestedImpl();
    }

    @Override
    public StepInfoFluent.StartTimeNested<A> withNewStartTimeLike(Time item) {
        return new StartTimeNestedImpl(item);
    }

    @Override
    public StepInfoFluent.StartTimeNested<A> editStartTime() {
        return this.withNewStartTimeLike(this.getStartTime());
    }

    @Override
    public StepInfoFluent.StartTimeNested<A> editOrNewStartTime() {
        return this.withNewStartTimeLike(this.getStartTime() != null ? this.getStartTime() : new TimeBuilder().build());
    }

    @Override
    public StepInfoFluent.StartTimeNested<A> editOrNewStartTimeLike(Time item) {
        return this.withNewStartTimeLike(this.getStartTime() != null ? this.getStartTime() : item);
    }

    @Override
    public A withNewStartTime(String time) {
        return this.withStartTime(new Time(time));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StepInfoFluentImpl that = (StepInfoFluentImpl)o;
        if (this.durationMilliseconds != null ? !this.durationMilliseconds.equals(that.durationMilliseconds) : that.durationMilliseconds != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null);
    }

    public class StartTimeNestedImpl<N>
    extends TimeFluentImpl<StepInfoFluent.StartTimeNested<N>>
    implements StepInfoFluent.StartTimeNested<N>,
    Nested<N> {
        private final TimeBuilder builder;

        StartTimeNestedImpl(Time item) {
            this.builder = new TimeBuilder(this, item);
        }

        StartTimeNestedImpl() {
            this.builder = new TimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)StepInfoFluentImpl.this.withStartTime(this.builder.build());
        }

        @Override
        public N endStartTime() {
            return this.and();
        }
    }
}

