/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TolerationFluent;
import io.fabric8.kubernetes.api.model.TolerationFluentImpl;

public class TolerationBuilder
extends TolerationFluentImpl<TolerationBuilder>
implements VisitableBuilder<Toleration, TolerationBuilder> {
    TolerationFluent<?> fluent;
    Boolean validationEnabled;

    public TolerationBuilder() {
        this(true);
    }

    public TolerationBuilder(Boolean validationEnabled) {
        this(new Toleration(), validationEnabled);
    }

    public TolerationBuilder(TolerationFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TolerationBuilder(TolerationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Toleration(), validationEnabled);
    }

    public TolerationBuilder(TolerationFluent<?> fluent, Toleration instance) {
        this(fluent, instance, true);
    }

    public TolerationBuilder(TolerationFluent<?> fluent, Toleration instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withEffect(instance.getEffect());
        fluent.withKey(instance.getKey());
        fluent.withOperator(instance.getOperator());
        fluent.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public TolerationBuilder(Toleration instance) {
        this(instance, (Boolean)true);
    }

    public TolerationBuilder(Toleration instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withEffect(instance.getEffect());
        this.withKey(instance.getKey());
        this.withOperator(instance.getOperator());
        this.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Toleration build() {
        Toleration buildable = new Toleration(this.fluent.getEffect(), this.fluent.getKey(), this.fluent.getOperator(), this.fluent.getValue());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TolerationBuilder that = (TolerationBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

