/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.rbac.KubernetesPolicyRule;
import io.fabric8.kubernetes.api.model.rbac.KubernetesPolicyRuleFluent;
import io.fabric8.kubernetes.api.model.rbac.KubernetesPolicyRuleFluentImpl;

public class KubernetesPolicyRuleBuilder
extends KubernetesPolicyRuleFluentImpl<KubernetesPolicyRuleBuilder>
implements VisitableBuilder<KubernetesPolicyRule, KubernetesPolicyRuleBuilder> {
    KubernetesPolicyRuleFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesPolicyRuleBuilder() {
        this(true);
    }

    public KubernetesPolicyRuleBuilder(Boolean validationEnabled) {
        this(new KubernetesPolicyRule(), validationEnabled);
    }

    public KubernetesPolicyRuleBuilder(KubernetesPolicyRuleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KubernetesPolicyRuleBuilder(KubernetesPolicyRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KubernetesPolicyRule(), validationEnabled);
    }

    public KubernetesPolicyRuleBuilder(KubernetesPolicyRuleFluent<?> fluent, KubernetesPolicyRule instance) {
        this(fluent, instance, true);
    }

    public KubernetesPolicyRuleBuilder(KubernetesPolicyRuleFluent<?> fluent, KubernetesPolicyRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiGroups(instance.getApiGroups());
        fluent.withNonResourceURLs(instance.getNonResourceURLs());
        fluent.withResourceNames(instance.getResourceNames());
        fluent.withResources(instance.getResources());
        fluent.withVerbs(instance.getVerbs());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesPolicyRuleBuilder(KubernetesPolicyRule instance) {
        this(instance, (Boolean)true);
    }

    public KubernetesPolicyRuleBuilder(KubernetesPolicyRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiGroups(instance.getApiGroups());
        this.withNonResourceURLs(instance.getNonResourceURLs());
        this.withResourceNames(instance.getResourceNames());
        this.withResources(instance.getResources());
        this.withVerbs(instance.getVerbs());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public KubernetesPolicyRule build() {
        KubernetesPolicyRule buildable = new KubernetesPolicyRule(this.fluent.getApiGroups(), this.fluent.getNonResourceURLs(), this.fluent.getResourceNames(), this.fluent.getResources(), this.fluent.getVerbs());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesPolicyRuleBuilder that = (KubernetesPolicyRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

