/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.events;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.events.EventSeries;
import io.fabric8.kubernetes.api.model.events.EventSeriesFluent;
import io.fabric8.kubernetes.api.model.events.EventSeriesFluentImpl;
import javax.validation.Validator;

public class EventSeriesBuilder
extends EventSeriesFluentImpl<EventSeriesBuilder>
implements VisitableBuilder<EventSeries, EventSeriesBuilder> {
    EventSeriesFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public EventSeriesBuilder() {
        this(true);
    }

    public EventSeriesBuilder(Boolean validationEnabled) {
        this(new EventSeries(), validationEnabled);
    }

    public EventSeriesBuilder(EventSeriesFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EventSeriesBuilder(EventSeriesFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EventSeries(), validationEnabled);
    }

    public EventSeriesBuilder(EventSeriesFluent<?> fluent, EventSeries instance) {
        this(fluent, instance, true);
    }

    public EventSeriesBuilder(EventSeriesFluent<?> fluent, EventSeries instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCount(instance.getCount());
        fluent.withLastObservedTime(instance.getLastObservedTime());
        fluent.withState(instance.getState());
        this.validationEnabled = validationEnabled;
    }

    public EventSeriesBuilder(EventSeries instance) {
        this(instance, (Boolean)true);
    }

    public EventSeriesBuilder(EventSeries instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCount(instance.getCount());
        this.withLastObservedTime(instance.getLastObservedTime());
        this.withState(instance.getState());
        this.validationEnabled = validationEnabled;
    }

    public EventSeriesBuilder(Validator validator) {
        this(new EventSeries(), (Boolean)true);
    }

    public EventSeriesBuilder(EventSeriesFluent<?> fluent, EventSeries instance, Validator validator) {
        this.fluent = fluent;
        fluent.withCount(instance.getCount());
        fluent.withLastObservedTime(instance.getLastObservedTime());
        fluent.withState(instance.getState());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public EventSeriesBuilder(EventSeries instance, Validator validator) {
        this.fluent = this;
        this.withCount(instance.getCount());
        this.withLastObservedTime(instance.getLastObservedTime());
        this.withState(instance.getState());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public EventSeries build() {
        EventSeries buildable = new EventSeries(this.fluent.getCount(), this.fluent.getLastObservedTime(), this.fluent.getState());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventSeriesBuilder that = (EventSeriesBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

